//
//  AMapPrivacyUtility.swift
//  VattiCSS
//
//  Created by WZR on 2023/9/6.
//

import Foundation
import UIKit

class AMapPrivacyUtility : NSObject {
    /**
     * @brief 通过这个方法来判断是否同意隐私合规
     * 1.如果没有同意隐私合规，则创建的SDK manager 实例返回 为nil， 无法使用SDK提供的功能
     * 2.如果同意了下次启动不提示 的授权，则不会弹框给用户
     * 3.如果只同意了，则下次启动还要给用户弹框提示
     */
    static func handlePrivacyAgreeStatus() {
        //判断是否需要同步了下次不提示
        if !UserDefaults.standard.bool(forKey: "agreeStatus") {
            //添加隐私合规弹窗
            showPrivacyInfoInWindow();
        }
    }
    
    /*
     * 展示隐私合规弹框
     */
    static func showPrivacyInfoInWindow(callBack:((Bool)->Void)? = nil){
        
        let paragraphStyle : NSMutableParagraphStyle = NSMutableParagraphStyle.init()
        paragraphStyle.alignment = NSTextAlignment.left
        var txt = ""
        if isEnglish() {
            txt = "\nDear, we have updated the Privacy Policy of AutoNavi Map in accordance with the latest regulatory requirements, and we would like to explain to you as follows: \n1. In order to provide you with basic transaction-related functions, we will collect and use necessary information; \n2. Based on your express authorization, we may obtain your location information, and you have the right to refuse or cancel your authorization; \n3. We will take the industry's most advanced security measures to protect your information security; \n4. We will not obtain, share or provide your information to third parties without your consent;"
        }else{
            txt = "\n亲，我们依据最新的监管要求更新了高德地图《隐私权政策》，特向您说明如下\n1.为向您提供交易相关基本功能，我们会收集、使用必要的信息；\n2.基于您的明示授权，我们可能会获取您的位置信息，您有权拒绝或取消授权；\n3.我们会采取业界先进的安全措施保护您的信息安全；\n4.未经您同意，我们不会从第三方处获取、共享或向提供您的信息；"
        }
        let privacyInfo : NSMutableAttributedString = NSMutableAttributedString.init(string: txt, attributes: [NSAttributedString.Key.paragraphStyle:paragraphStyle])
        
        
        privacyInfo.setAttributes([NSAttributedString.Key.foregroundColor:UIColor.blue], range: privacyInfo.mutableString.range(of: "《隐私权政策》".languageString()))
        
        let privacyInfoController : UIAlertController = UIAlertController.init(title: "温馨提示".languageString(), message: "", preferredStyle: UIAlertController.Style.alert)
        
        privacyInfoController.setValue(privacyInfo, forKey: "attributedMessage")
        
        let agreeAllAction : UIAlertAction = UIAlertAction.init(title: "同意".languageString(), style: UIAlertAction.Style.default) { UIAlertAction in
            UserDefaults.standard.set(true, forKey: "agreeStatus")
            UserDefaults.standard.synchronize()
            //更新用户授权高德SDK隐私协议状态. since 8.1.0
            AMapLocationManager.updatePrivacyAgree(AMapPrivacyAgreeStatus.didAgree)
            callBack?(true)
        }
        
//        let agreeAction : UIAlertAction = UIAlertAction.init(title: "同意", style: UIAlertAction.Style.default) { UIAlertAction in
//            //更新用户授权高德SDK隐私协议状态. since 8.1.0
//            AMapLocationManager.updatePrivacyAgree(AMapPrivacyAgreeStatus.didAgree)
//            callBack?(true)
//        }
        
        
    
        let notAgreeAction : UIAlertAction = UIAlertAction.init(title: "不同意".languageString(), style: UIAlertAction.Style.default) { UIAlertAction in
            UserDefaults.standard.set(false, forKey: "agreeStatus")
            UserDefaults.standard.synchronize()
            //更新用户授权高德SDK隐私协议状态. since 8.1.0
            AMapLocationManager.updatePrivacyAgree(AMapPrivacyAgreeStatus.notAgree)
            callBack?(false)
        }
        
        
        privacyInfoController.addAction(agreeAllAction)
//        privacyInfoController.addAction(agreeAction)
        privacyInfoController.addAction(notAgreeAction)
        (UIApplication.shared.delegate as! AppDelegate).window?.rootViewController?.present(privacyInfoController, animated: true, completion: {
            //更新App是否显示隐私弹窗的状态，隐私弹窗是否包含高德SDK隐私协议内容的状态. since 8.1.0
            AMapLocationManager.updatePrivacyShow(AMapPrivacyShowStatus.didShow, privacyInfo: AMapPrivacyInfoStatus.didContain)
        })
    }
}
