//
//  NewVersionAlertVc.swift
//  Annette
//
//  Created by fishxiaou on 2023/6/17.
//

import UIKit

class NewVersionAlertVc: UIViewController {
    
    @IBOutlet weak var subMainView: UIView!
    @IBOutlet weak var contentLab: UILabel!
    @IBOutlet weak var cancelBtn: UIButton!
    @IBOutlet weak var sender: UIButton!
    
    var updateInfo = ""
    var appStoreUrl = ""
    
    class func getInstance(_ info:String, url: String) -> NewVersionAlertVc {
        let showView = NewVersionAlertVc(nibName: "NewVersionAlertVc", bundle: nil)
        showView.updateInfo = info
        showView.appStoreUrl = url
        showView.modalPresentationStyle = .overFullScreen
        return showView
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        subMainView.makeLayerRadius(value: 8)
        if !updateInfo.isEmpty {
            contentLab.text = updateInfo
        }
    }
    
    @IBAction func cancelAction(_ sender: UIButton) {
        dismiss(animated: true)
    }
    
    @IBAction func senderAction(_ sender: UIButton) {
        dismiss(animated: true)
        guard let apUrl = URL(string: appStoreUrl) else { return }
        DispatchQueue.main.async {
            UIApplication.shared.open(apUrl)
        }
    }
    
}
