//
//  TSDatePickerVC.swift
//  USSHome
//
//  Created by YouT on 2021/10/21.
//  
/*
 TSDatePickerVC.showDatePicker(titleStr: "请选择购买日期", maxDate: Date(), minDate: nil) { [weak self] (selDate) in
     guard let weakSelf = self else { return }
     let format = DateFormatter()
     format.dateFormat = "yyyy-MM-dd"
     weakSelf.model.buytime = format.string(from: selDate)
     weakSelf.makeForms()
 }.show(UIViewController.ts_visible())

 */
import UIKit

@objcMembers class TSDatePickerVC: UIViewController {

    @IBOutlet weak var mainStackView: UIStackView!
    @IBOutlet weak var titleLabel: UILabel!
    
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var mainDatePicker: UIDatePicker!
    
    @IBOutlet weak var submitButton: UIButton!
    
    // -364
    @IBOutlet weak var viewBottomLC: NSLayoutConstraint!
    
    var titleStr = ""
    var minimumDate:Date?
    var maximumDate:Date?
    var pickerMode:UIDatePicker.Mode = .date
    var datePickerEnd:((Date)->())?
    
    // 显示
    class func showDatePicker(titleStr:String, maxDate:Date?, minDate:Date?, mode:UIDatePicker.Mode = .date, action:@escaping ((Date)->())) -> TSDatePickerVC  {
        let curView = TSDatePickerVC(nibName: "TSDatePickerVC", bundle: nil)
        curView.titleStr = titleStr
        curView.minimumDate = minDate
        curView.maximumDate = maxDate
        curView.datePickerEnd = action
        curView.pickerMode = mode
        return curView
    }
    
    func show(_ from:UIViewController) {
        self.modalPresentationStyle = .overFullScreen
        self.modalTransitionStyle = .crossDissolve
        from.present(self, animated: true, completion: nil)
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()

        if !titleStr.isEmpty {
            titleLabel.text = titleStr
        }
        
        submitButton.layer.cornerRadius = 5
        submitButton.layer.masksToBounds = true
        submitButton.setTitle("确定".languageString(), for: .normal)
        mainDatePicker.minimumDate = minimumDate
        mainDatePicker.maximumDate = maximumDate
        mainDatePicker.datePickerMode = pickerMode
        
        if isEnglish(){
            mainDatePicker.locale = Locale(identifier: "en")
        }else{
            mainDatePicker.locale = Locale(identifier: "zh")
        }
        
    }
    
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(animated)
        
        mainStackView.layer.masksToBounds = true
        mainStackView.makeLayerRadius(value: 8,type: [.layerMinXMinYCorner, .layerMaxXMinYCorner])
        bgView.makeLayerRadius(value: 8,type: [.layerMinXMinYCorner, .layerMaxXMinYCorner])
        submitButton.makeLayerRadius(value: 5,type: [.layerMaxXMaxYCorner,.layerMaxXMinYCorner,.layerMinXMaxYCorner,.layerMinXMinYCorner])
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        viewBottomLC.constant = -364
        view.layoutIfNeeded()
        bgView.isHidden = false
        mainStackView.isHidden = false

        DispatchQueue.main.asyncAfter(deadline: DispatchTime.now()+0.1) { [weak self] () in
            self?.animateShow()
        }
    }
    
    @IBAction func cancelAction(_ sender: Any) {
        dismiss(animated: true, completion: nil )
    }
    
    @IBAction func submitAction(_ sender: UIButton) {
        let selDate = mainDatePicker.date
        datePickerEnd?(selDate)
        dismiss(animated: true, completion: nil)
    }
    
    func animateShow() {
        viewBottomLC.constant = -364
        UIView.animate(withDuration: 0.5, delay: 0, options: UIView.AnimationOptions.allowAnimatedContent, animations: { [weak self] in
            guard let weakSelf = self else { return }
            weakSelf.viewBottomLC.constant = 0
            weakSelf.view.layoutIfNeeded()
        }) {  _ in
            
        }
    }
    
}
