//
//  TCFormCellConfigModel.swift
//  TooneCRM
//
//  Created by fishxiaou on 2022/4/14.
//

import Foundation
import UIKit

// Cell 样式通用设置
class TCFormCellConfigModel {
    
    // 背景
    var cellColor = UIColor.white
    var bgColor = UIColor.white
    // iconView背景
    var iconViewBgColor = UIColor.white
    // 标题
    var titleText = ""
    var titleNumberOfLine = 0
    var titleFont = UIFont.PingFangRegular(size: 14)
    var titleColor = UIColor(hexString: "#333333")
    // info
    var infoFont = UIFont.PingFangRegular(size: 14)
    var infoColor = UIColor(hexString: "#666666")
    var infoNumberOfLine = 2
    
    //单位名称
    var unitText = ""
    // 是否显示 必填必填标识*
    var showTipLabel = false
    // 是否显示 分割线
    var showLineView = true
    // 是否显示 箭头图标
    var showNextView = false
    var nextViewImageStr = "mine_btn_next"
    
    var showIconView = false
    var iconImage: UIImage?
   
    
    /// bgView左右间距
    var bgViewLRMargin:CGFloat = 0
    /// 圆角
    var cornerRadius:CGFloat?
    var cornerMask:CACornerMask?
    
    //bgView 两边约束
    var bgViewLeading:CGFloat?
    var bgViewTrailing:CGFloat?
    
    // 是否可以编辑
    var canEdit = true
    
    var styleText = ""
    
    var textAlignment = NSTextAlignment.right
    
    var titleAlignment = NSTextAlignment.left
    
    convenience init(titleStr: String) {
        self.init()
        self.titleText = titleStr
    }
    
    class func defaultModel() -> TCFormCellConfigModel {
        return TCFormCellConfigModel()
    }
    
    func setTitleNumberOfLine(_ i:Int) -> TCFormCellConfigModel {
        titleNumberOfLine = i
        return self
    }
    
    func setInfoNumberOfLine(_ i:Int) -> TCFormCellConfigModel {
        infoNumberOfLine = i
        return self
    }
    
    func setBgViewLeading(_ c:CGFloat) -> TCFormCellConfigModel {
        bgViewLeading = c
        return self
    }
    
    func setBgViewTrailing(_ c:CGFloat) -> TCFormCellConfigModel {
        bgViewTrailing = c
        return self
    }
    
    func bgColor(_ b:UIColor) -> TCFormCellConfigModel {
        bgColor = b
        return self
    }
    
    func setCellColor(_ b:UIColor) -> TCFormCellConfigModel {
        cellColor = b
        return self
    }
    
    
    func iconViewbgColor(_ b:UIColor) -> TCFormCellConfigModel {
        iconViewBgColor = b
        return self
    }
    
    func title(_ ts:String) -> TCFormCellConfigModel {
        titleText = ts
        return self
    }
    
    //样式区分
    func styleText(_ ts:String) -> TCFormCellConfigModel {
        styleText = ts
        return self
    }
    
    func titleFont(_ tf:UIFont) -> TCFormCellConfigModel {
        titleFont = tf
        return self
    }
    
    func titleColor(_ tc:UIColor) -> TCFormCellConfigModel {
        titleColor = tc
        return self
    }
    
    func infoColor(_ c:UIColor) -> TCFormCellConfigModel {
        infoColor = c
        return self
    }
    
    func infoFont(_ tf:UIFont) -> TCFormCellConfigModel {
        infoFont = tf
        return self
    }
    
    func unitText(_ ts:String) -> TCFormCellConfigModel {
        unitText = ts
        return self
    }
    
    func showTip(_ st:Bool) -> TCFormCellConfigModel {
        showTipLabel = st
        return self
    }
    
    func showLine(_ sl:Bool) -> TCFormCellConfigModel {
        showLineView = sl
        return self
    }
    
    func showNext(_ sn:Bool) -> TCFormCellConfigModel {
        showNextView = sn
        return self
    }
    
    func nextImageStr(_ ts:String) -> TCFormCellConfigModel {
        nextViewImageStr = ts
        return self
    }
    
    func showIconView(_ si:Bool) -> TCFormCellConfigModel {
        showIconView = si
        return self
    }
    
    func iconImage(_ img:UIImage?) -> TCFormCellConfigModel {
        iconImage = img
        return self
    }
    
    func bgViewLRMargin(_ m:CGFloat) -> TCFormCellConfigModel {
        bgViewLRMargin = m
        return self
    }
    
    func cornerRadius(_ cr:CGFloat) -> TCFormCellConfigModel {
        cornerRadius = cr
        return self
    }
    
    func cornerMask(_ cr:CACornerMask) -> TCFormCellConfigModel {
        cornerMask = cr
        return self
    }
    
    func canEdit(_ canE:Bool) -> TCFormCellConfigModel {
        canEdit = canE
        return self
    }
    
    func textAlignment(_ ali:NSTextAlignment) -> TCFormCellConfigModel {
        textAlignment = ali
        return self
    }
    
    func titleAlignment(_ ali:NSTextAlignment) -> TCFormCellConfigModel {
        titleAlignment = ali
        return self
    }
    
}
