//
//  TCFormCellModel.swift
//  TooneCRM
//
//  Created by fishxiaou on 2022/4/14.
//

import Foundation

//MARK:-------------------- 表单协议 --------------------

public typealias TCRowDidSelectBlock = () -> Void
public typealias TCRowCallBack = (Any?) -> Void

//MARK:--- UI 数据源和配置协议 ----------
public typealias TCCell_UIDataSourceConfigModel = TCCell_UIDataSource & TCCell_UIConfigModel
//MARK:--- UI 数据源协议， ----------
public protocol TCCell_UIDataSource {
    associatedtype DataSource
    var dataSource:DataSource? { set get }
    func row_update(dataSource data: DataSource)
}
extension TCCell_UIDataSource {
    public var dataSource: DataSource? {
        get { return nil }
        set {}
    }
    func row_update(dataSource data: DataSource) {}
}
//MARK:--- UI 配置协议， ----------
public protocol TCCell_UIConfigModel {
    associatedtype ConfigModel
    var config:ConfigModel? { set get }
    func row_update(config data: ConfigModel)
}
extension TCCell_UIConfigModel {
    public var config: ConfigModel? {
        get { return nil }
        set {}
    }
    func row_update(config data: ConfigModel){}
}

//MARK:---  数据源更新协议 ---
public protocol TCCell_RowCellUpdateProtocol:TCCell_UIDataSourceConfigModel {
    func row_update(callBack block:TCRowCallBack?)
}
extension TCCell_RowCellUpdateProtocol {
    public func row_update(config data: ConfigModel) {}
    public func row_update(dataSource data: DataSource) {}
    public func row_update(callBack block:TCRowCallBack?) {}
}


//MARK:--- UI 协议 ----------
public protocol TCCellBaseProtocol {
    
    var cellId: String { get }
    var cellClass:AnyClass { get }
    var frameH:CGFloat { set get }
    var dataSource:Any? { set get }
    var config:Any? { set get }
    var callBack:TCRowCallBack?{ set get }
    var tapBlock:TCRowDidSelectBlock?{ set get }
    func bind(_ obj: AnyObject)
}

extension TCCellBaseProtocol {
    public var callBack:TCRowCallBack?{ set{} get{ return nil} }
    public var tapBlock:TCRowDidSelectBlock?{ set{} get{ return nil} }
    
    public func bind(_ obj: AnyObject) {
        
    }
}


public struct TCFormCellModel<T:TCCell_RowCellUpdateProtocol>:TCCellBaseProtocol where T: UIView {
    public var cellId: String
    public var cellClass:AnyClass
    public var _dataSource:T.DataSource?
    public var _config:T.ConfigModel?
    public var frameH:CGFloat
    public var callBack:TCRowCallBack?
    public var _didSelect:TCRowDidSelectBlock?
    /*
     data  ：View Data 数据源
     callBack ： View 类内执行回调
     didSelect ： View 点击回调 UITableView | UICollectionView didSelectRow
     */
    public init(data: T.DataSource? = nil,
                config:T.ConfigModel? = nil,
                id: String? = nil,
                frameh:CGFloat = 0,
                callBack:TCRowCallBack? = nil,
                didSelect:TCRowDidSelectBlock? = nil) {
        self._dataSource = data
        self._config = config
        self.cellClass = T.self
        self.cellId = id ?? String(describing: T.self)
        self.frameH = frameh
        self.callBack = callBack
        self._didSelect = didSelect
    }
    
    public func bind(_ obj: AnyObject) {
        guard let item = obj as? T else {return}
        if let m = _config {
            item.row_update(config: m)
        }
        if let d = _dataSource {
            item.row_update(dataSource:d)
        }
        
        if let back = callBack  {
            item.row_update(callBack: back)
        }
    }
    public var dataSource: Any? {
        set{
            _dataSource = newValue as? T.DataSource
        }
        get{
            return _dataSource
        }
    }
    public var config: Any? {
        set{
            _config = newValue as? T.ConfigModel
        }
        get{
            return _config
        }
    }
}
extension TCFormCellModel {
    public var tapBlock: TCRowDidSelectBlock? {
        get { return _didSelect}
        set { _didSelect = newValue}
    }
}
