//
//  Cell_DottedLine.swift
//  VattiCSS
//
//  Created by Jan on 2023/9/13.
//  - 虚线

import UIKit

class Cell_DottedLine: UITableViewCell {
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var bgLeadingC: NSLayoutConstraint!
    @IBOutlet weak var bgTrailingC: NSLayoutConstraint!
    @IBOutlet weak var width_lineViewC: NSLayoutConstraint!
    @IBOutlet weak var lineViewTrailingC: NSLayoutConstraint!
    @IBOutlet weak var lineViewLeadingC: NSLayoutConstraint!
    
    @IBOutlet weak var lineView: UIView!
    override func awakeFromNib() {
        super.awakeFromNib()
        self.selectionStyle = .none
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
    }
    
}


extension Cell_DottedLine: TCCell_RowCellUpdateProtocol {
    // value、placeholder
    typealias DataSource = (CGFloat?,UIColor)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(config data: TCFormCellConfigModel) {
        self.backgroundColor = data.cellColor
        self.bgView.backgroundColor = data.bgColor
        bgLeadingC.constant = data.bgViewLeading ?? 12
        bgTrailingC.constant = data.bgViewTrailing ?? 12
    }
    
    func row_update(dataSource data: (CGFloat?,UIColor)) {
        width_lineViewC.constant = data.0 ?? 0.5
        self.lineView.backgroundColor = .clear
        self.lineView.drawDashLine(CGRect(x: 0, y: 0, width: SCREEN_W-50, height: 0.5), strokeColor: data.1, lineWidth: 0.5, lineLength: 6, lineSpacing: 6)
    }
    
}
