//
//  TCCopyTextViewCell.swift
//  Service
//
//  Created by Jan on 2023/7/26.
//  Copyright © 2023 yus. All rights reserved.
//

import UIKit

class TCCopyTextViewCell: UITableViewCell, UITextViewDelegate {

    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var cellTextView: UITextView!
    @IBOutlet weak var lineView: UIView!
    
    // 事件
    var callBack: TCRowCallBack?
    
    override func awakeFromNib() {
        super.awakeFromNib()
        self.selectionStyle = .none
        cellTextView.delegate = self
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
    }
    
    func textViewDidChange(_ textView: UITextView) {
        callBack?((UIControl.Event.editingChanged,textView.text ?? ""))
    }
    
    func textViewDidEndEditing(_ textView: UITextView) {
//        callBack?((UIControl.Event.editingDidEnd,textView.text ?? ""))
        callBack?((textView.text ?? ""))
    }
    
}

extension TCCopyTextViewCell:TCCell_RowCellUpdateProtocol {
    // value、placeholder 、输入正则
    typealias DataSource = (String,String,String)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
    func row_update(config data: TCFormCellConfigModel) {
        lineView.isHidden = !data.showLineView
        cellTextView.isEditable = data.canEdit
    }
    
    func row_update(dataSource data: (String, String, String)) {
        cellTextView.text = data.0
        cellTextView.placeholder = data.1
    }
    
}

