//
//  TCCustomImageCell.swift
//  Toone
//
//  Created by fishxiaou on 2022/11/7.
//

import UIKit

class TCCustomImageCell: UITableViewCell {
    
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var mainCollectionView: UICollectionView!
    @IBOutlet weak var lineView: UIView!
    // 按钮内部事件  1删除 2大图 3新增
    var callBack: TCRowCallBack?
    
    // 是否可以编辑
    var canEdit = false
    // 最大图片数
    var maxCount:UInt = 6
    // 图片
    var imageModelArr = [TCFormImageModel]()
    
    override func awakeFromNib() {
        super.awakeFromNib()
        self.selectionStyle = .none
        mainCollectionView.register(UINib(nibName: "TCImageCollectionCell", bundle: nil), forCellWithReuseIdentifier: "TCImageCollectionCell")
        mainCollectionView.delegate = self
        mainCollectionView.dataSource = self
    }
    
    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
    }
    
}

extension TCCustomImageCell: TCCell_RowCellUpdateProtocol {
    // 图片组
    typealias DataSource = [TCFormImageModel]
    // 是否显示底部分割线、是否可以编辑
    typealias ConfigModel = (Bool,Bool,UInt?)
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
    func row_update(dataSource data: [TCFormImageModel]) {
        imageModelArr = data
        mainCollectionView.reloadData()
    }
    
    func row_update(config data: (Bool, Bool, UInt?)) {
        lineView.isHidden = !data.0
        canEdit = data.1
        if let maxC = data.2 {
            maxCount = maxC
        }
        mainCollectionView.reloadData()
    }
    
}

extension TCCustomImageCell: UICollectionViewDelegate, UICollectionViewDataSource, UICollectionViewDelegateFlowLayout {
    
    func numberOfSections(in collectionView: UICollectionView) -> Int {
        if canEdit && imageModelArr.count < maxCount {
            return 2
        }else{
            return 1
        }
    }
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        if section == 0 {
            return imageModelArr.count
        }else{
            return 1
        }
        
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "TCImageCollectionCell", for: indexPath) as! TCImageCollectionCell
        if indexPath.section == 0 {
            cell.deleteButton.isHidden = true
            let imageM = imageModelArr[indexPath.row]
            if !imageM.imageUrl.isEmpty {
                cell.cellImageView.sd_setImage(with: URL(string: imageM.imageUrl))
                cell.deleteButton.isHidden = false
            }else if let curImg = imageM.image {
                cell.cellImageView.image = curImg
                cell.deleteButton.isHidden = false
            }
            if !canEdit {
                cell.deleteButton.isHidden = true
            }
            cell.tipLabel.isHidden = !imageM.isMust
            cell.titleLabel.text = imageM.nameStr
            cell.actionCall = { [weak self] () in
                self?.callBack?((1,indexPath.row))
            }
        }else{
            cell.cellImageView.image = UIImage(named: "list_add_pic")
            cell.deleteButton.isHidden = true
        }
        return cell
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        return CGSize(width: 70, height: 70)
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, insetForSectionAt section: Int) -> UIEdgeInsets {
        if section == 0 {
            return UIEdgeInsets.zero
        }else{
            if imageModelArr.isEmpty {
                return UIEdgeInsets.zero
            }else{
                return UIEdgeInsets(top: 0, left: 15, bottom: 0, right: 0)
            }
        }
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, minimumLineSpacingForSectionAt section: Int) -> CGFloat {
        return 15
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, minimumInteritemSpacingForSectionAt section: Int) -> CGFloat {
        return 15
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        if indexPath.section == 0 {
            callBack?((2,indexPath.row))
        }else{
            callBack?((3,indexPath.row))
        }
    }
    
}

