//
//  TCDatePeriodCell.swift
//  TooneCRM
//
//  Created by fishxiaou on 2022/4/20.
//

import UIKit

class TCDatePeriodCell: UITableViewCell {

    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var titleLabel: UILabel!
    @IBOutlet weak var lineView: UIView!
    
    @IBOutlet weak var starView: UIView!
    @IBOutlet weak var starLabel: UILabel!
    @IBOutlet weak var starDateLabel: UILabel!
    @IBOutlet weak var starNextView: UIImageView!
    
    @IBOutlet weak var midLine: UIView!
    
    @IBOutlet weak var endView: UIView!
    @IBOutlet weak var endLabel: UILabel!
    @IBOutlet weak var endDateLabel: UILabel!
    @IBOutlet weak var endNextView: UIImageView!
    
    // 按钮内部事件
    var callBack: TCRowCallBack?
    
    override func awakeFromNib() {
        super.awakeFromNib()
        self.selectionStyle = .none
        starNextView.image = UIImage(named: "home_icon_next")
        endNextView.image = UIImage(named: "home_icon_next")
    }
    @IBAction func dateButtonAction(_ sender: UIButton) {
        // 1 开始   2 结束
        callBack?(sender.tag)
    }
    
    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
    }
    
}

extension TCDatePeriodCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = (sTitle:String, sValue: String, eTitle:String, eValue: String)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
    func row_update(config data: TCFormCellConfigModel) {
        bgView.backgroundColor = data.bgColor
        titleLabel.textColor = data.titleColor
        titleLabel.font = data.titleFont
        if data.showTipLabel {
            let showStr = NSMutableAttributedString(string: data.titleText)
            showStr.append(NSAttributedString(string: "*", attributes: [NSAttributedString.Key.foregroundColor : UIColor(hexString: "#F7544D")]))
            titleLabel.attributedText = showStr
        }else{
            titleLabel.text = data.titleText
        }
        lineView.isHidden = !data.showLineView
        
        starNextView.isHidden = !data.canEdit
        endNextView.isHidden = !data.canEdit
    }
    
    func row_update(dataSource data: (sTitle: String, sValue: String, eTitle: String, eValue: String)) {
        starLabel.text = data.sTitle
        endLabel.text = data.eTitle
        
        if data.sValue.isEmpty {
            starDateLabel.text = "请选择"
            starDateLabel.textColor = UIColor(hexString: "#C7C7CC")
        }else{
            starDateLabel.text = data.sValue
            starDateLabel.textColor = UIColor(hexString: "#626266")
        }
        
        if data.eValue.isEmpty {
            endDateLabel.text = "请选择"
            endDateLabel.textColor = UIColor(hexString: "#C7C7CC")
        }else{
            endDateLabel.text = data.eValue
            endDateLabel.textColor = UIColor(hexString: "#626266")
        }
    }
    
    
}
