//
//  TCFileCell.swift
//  TooneCRM
//
//  Created by fishxiaou on 2022/4/20.
//

import UIKit

class TCFileCell: UITableViewCell {
    
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var titleLabel: UILabel!
    @IBOutlet weak var nameLabel: UILabel!
    @IBOutlet weak var lineView: UIView!
    
    @IBOutlet weak var deleteButton: UIButton!
    @IBOutlet weak var nextView: UIView!
    @IBOutlet weak var addButton: UIButton!
    
    var canEdit = true
    
    // 按钮内部事件
    var callBack: TCRowCallBack?
    
    override func awakeFromNib() {
        super.awakeFromNib()
        
        deleteButton.setImage(UIImage(named: "ico_f_small_delete"), for: .normal)
        addButton.setImage(UIImage(named: "ico_small_add"), for: .normal)
    }
    
    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
        
    }
    
    @IBAction func addButtonAction(_ sender: UIButton) {
        callBack?(1)
    }
    
    @IBAction func deleteButtonAction(_ sender: UIButton) {
        callBack?(2)
    }
    
}


extension TCFileCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = String
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
    func row_update(config data: TCFormCellConfigModel) {
        bgView.backgroundColor = data.bgColor
        titleLabel.textColor = data.titleColor
        titleLabel.font = data.titleFont
        if data.showTipLabel {
            let showStr = NSMutableAttributedString(string: data.titleText)
            showStr.append(NSAttributedString(string: "*", attributes: [NSAttributedString.Key.foregroundColor : UIColor(hexString: "#F7544D")]))
            titleLabel.attributedText = showStr
        }else{
            titleLabel.text = data.titleText
        }
        
        canEdit = data.canEdit
        lineView.isHidden = !data.showLineView
    }
    
    func row_update(dataSource data: String) {
        if canEdit {
            if data.isEmpty {
                nameLabel.text = ""
                nextView.isHidden = false
                deleteButton.isHidden = true
            }else{
                nameLabel.text = data
                nextView.isHidden = true
                deleteButton.isHidden = false
            }
        }else{
            nameLabel.text = data
            nextView.isHidden = true
            deleteButton.isHidden = true
        }
    }
}
