//
//  TCGPSCell.swift
//  TooneCRM
//
//  Created by fishxiaou on 2022/4/22.
//

import UIKit

class TCGPSCell: UITableViewCell, UITextViewDelegate {
    
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var titleLabel: UILabel!
    
    @IBOutlet weak var lineView: UIView!
    
    @IBOutlet weak var sunSuperView: UIView!
    @IBOutlet weak var gpsView: UIView!
    @IBOutlet weak var cellTextView: UITextView!
    @IBOutlet weak var gpsIconView: UIImageView!
    @IBOutlet weak var cellButton: UIButton!
    
    // 事件
    var callBack: TCRowCallBack?
    
    override func awakeFromNib() {
        super.awakeFromNib()
        self.selectionStyle = .none
        cellTextView.delegate = self
        gpsIconView.image = UIImage(named: "shop_ico_local")
        
        sunSuperView.layer.borderWidth = 0.8
        sunSuperView.layer.borderColor = UIColor(hexString: "#E6E6E6").cgColor
        
        gpsView.layer.borderWidth = 0.8
        gpsView.layer.borderColor = UIColor(hexString: "#E6E6E6").cgColor
    }
    
    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
    }
    
    @IBAction func cellButtonAction(_ sender: UIButton) {
        callBack?((3,""))
    }
    
    func textViewDidChange(_ textView: UITextView) {
        callBack?((1,textView.text ?? ""))
    }
    
    func textViewDidEndEditing(_ textView: UITextView) {
        callBack?((2,textView.text ?? ""))
    }
    
}

extension TCGPSCell:TCCell_RowCellUpdateProtocol {
    // value、placeholder 、输入正则
    typealias DataSource = (String,String)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
    func row_update(config data: TCFormCellConfigModel) {
        bgView.backgroundColor = data.bgColor
        titleLabel.textColor = data.titleColor
        titleLabel.font = data.titleFont
        if data.showTipLabel {
            let showStr = NSMutableAttributedString(string: data.titleText)
            showStr.append(NSAttributedString(string: "*", attributes: [NSAttributedString.Key.foregroundColor : UIColor(hexString: "#F7544D")]))
            titleLabel.attributedText = showStr
        }else{
            titleLabel.text = data.titleText
        }
        lineView.isHidden = !data.showLineView
        
        cellTextView.isEditable = data.canEdit
    }
    
    func row_update(dataSource data: (String, String)) {
        cellTextView.text = data.0
        cellTextView.placeholder = data.1
    }
    
}
