//
//  TCHeaderCell.swift
//  TooneCRM
//
//  Created by fishxiaou on 2022/4/14.
//

import UIKit

class TCHeaderCell: UITableViewCell {

    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var iconView: UIView!
    @IBOutlet weak var iconLineView: UIView!
    @IBOutlet weak var titleLabel: UILabel!
    @IBOutlet weak var actionView: UIView!
    @IBOutlet weak var actionViewWLC: NSLayoutConstraint!
    @IBOutlet weak var actionButton: UIButton!
    @IBOutlet weak var lineView: UIView!
    
    // 按钮内部事件
    var callBack: TCRowCallBack?
    
    override func awakeFromNib() {
        super.awakeFromNib()
        self.selectionStyle = .none
        actionButton.layer.cornerRadius = 2
        actionButton.layer.masksToBounds = true
        actionView.isHidden = true
    }
    
    @IBAction func buttonAction(_ sender: UIButton) {
        callBack?(sender.tag)
    }
    
    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
    }
}

extension TCHeaderCell: TCCell_RowCellUpdateProtocol {
    // 是否显示按钮 按钮图标、按钮标题、按钮标题颜色、按钮宽度、边框颜色
    typealias DataSource = (Bool, String, String, UIColor, CGFloat, UIColor?)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
    func row_update(config data: TCFormCellConfigModel) {
        bgView.backgroundColor = data.bgColor
        iconLineView.backgroundColor = data.iconViewBgColor
        iconView.isHidden = !data.showIconView
        titleLabel.textColor = data.titleColor
        titleLabel.font = data.titleFont
        if data.showTipLabel {
            let showStr = NSMutableAttributedString(string: data.titleText)
            showStr.append(NSAttributedString(string: "*", attributes: [NSAttributedString.Key.foregroundColor : UIColor(hexString: "#F7544D")]))
            titleLabel.attributedText = showStr
        }else{
            titleLabel.text = data.titleText
        }
        lineView.isHidden = !data.showLineView
    }
    
    
    func row_update(dataSource data: (Bool, String, String, UIColor, CGFloat, UIColor?)) {
        guard data.0 else {
            actionView.isHidden = true
            return
        }
        actionView.isHidden = false
        actionViewWLC.constant = data.4
        if !data.1.isEmpty {
            actionButton.setImage(UIImage(named: data.1), for: .normal)
        }else{
            actionButton.setImage(nil, for: .normal)
        }
        actionButton.setTitle(" " + data.2, for: .normal)
        actionButton.setTitleColor(data.3, for: .normal)
        if let boardColor = data.5 {
            actionButton.layer.borderColor = boardColor.cgColor
            actionButton.layer.borderWidth = 1
        }else{
            actionButton.layer.borderWidth = 0
        }
    }
    
}

