//
//  TCImageCell.swift
//  TooneCRM
//
//  Created by fishxiaou on 2022/4/15.
//

import UIKit

class TCImageCell: UITableViewCell {
    
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var mainCollectionView: UICollectionView!
    @IBOutlet weak var lineView: UIView!
    // 按钮内部事件
    var callBack: TCRowCallBack?
    
    var canEdit = false
    var imageModelArr = [TCFormImageModel]()
    
    override func awakeFromNib() {
        super.awakeFromNib()
        self.selectionStyle = .none
        mainCollectionView.register(UINib(nibName: "TCImageCollectionCell", bundle: nil), forCellWithReuseIdentifier: "TCImageCollectionCell")
        mainCollectionView.delegate = self
        mainCollectionView.dataSource = self
    }
    
    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
    }
    
}

extension TCImageCell: TCCell_RowCellUpdateProtocol {
    // 图片组
    typealias DataSource = [TCFormImageModel]
    // 是否显示底部分割线、是否可以编辑
    typealias ConfigModel = (Bool,Bool)
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
    func row_update(dataSource data: [TCFormImageModel]) {
        imageModelArr = data
        mainCollectionView.reloadData()
    }
    
    func row_update(config data: (Bool, Bool)) {
        lineView.isHidden = !data.0
        canEdit = data.1
    }
}

extension TCImageCell: UICollectionViewDelegate, UICollectionViewDataSource, UICollectionViewDelegateFlowLayout {
    
    func numberOfSections(in collectionView: UICollectionView) -> Int {
        return 1
    }
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return imageModelArr.count
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let imageM = imageModelArr[indexPath.row]
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "TCImageCollectionCell", for: indexPath) as! TCImageCollectionCell
        cell.cellImageView.image = UIImage(named: "list_add_pic")
        cell.deleteButton.isHidden = true
        if !imageM.imageUrl.isEmpty {
            cell.cellImageView.sd_setImage(with: URL(string: imageM.imageUrl))
            cell.deleteButton.isHidden = false
        }else if let curImg = imageM.image {
            cell.cellImageView.image = curImg
            cell.deleteButton.isHidden = false
        }
        if !canEdit {
            cell.deleteButton.isHidden = true
        }
        cell.tipLabel.isHidden = !imageM.isMust
        cell.titleLabel.text = imageM.nameStr
        cell.actionCall = { [weak self] () in
            self?.callBack?((1,indexPath.row))
        }
        return cell
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        return CGSize(width: 70, height: 91)
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, insetForSectionAt section: Int) -> UIEdgeInsets {
        return UIEdgeInsets.zero
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, minimumLineSpacingForSectionAt section: Int) -> CGFloat {
        return 15
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, minimumInteritemSpacingForSectionAt section: Int) -> CGFloat {
        return 15
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        callBack?((2,indexPath.row))
    }
    
}
