//
//  TCLineCell.swift
//  TooneCRM
//
//  Created by fishxiaou on 2022/4/15.
//

import UIKit

class TCLineCell: UITableViewCell {
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var lineViewLLC: NSLayoutConstraint!
    @IBOutlet weak var lineViewRLC: NSLayoutConstraint!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        self.selectionStyle = .none
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
    }
    
}

extension TCLineCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = (CGFloat?,CGFloat?,UIColor?)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(config data: TCFormCellConfigModel) {
        backgroundColor = data.bgColor
        bgView.makeLayerRadius(value: data.cornerRadius ?? 0.0, type: data.cornerMask ?? [.layerMaxXMaxYCorner,.layerMaxXMinYCorner,.layerMinXMaxYCorner,.layerMinXMinYCorner])
    }
    
    func row_update(dataSource data: (CGFloat?, CGFloat?, UIColor?)) {
        lineViewLLC.constant = data.0 ?? 15
        lineViewRLC.constant = data.1 ?? 15
        bgView.backgroundColor = data.2 ?? UIColor(hexString: "#F8F8F8")
    }
    
}
