//
//  TCSubmitButtonCell.swift
//  Service
//
//  Created by Jan on 2023/6/13.
//  Copyright © 2023 yus. All rights reserved.
//

import UIKit

class TCSubmitButtonCell: UITableViewCell {

    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var actionView: UIView!
    @IBOutlet weak var actionButton: UIButton!
    // 按钮内部事件
    var callBack: TCRowCallBack?
    
    override func awakeFromNib() {
        super.awakeFromNib()
        self.selectionStyle = .none
        actionButton.layer.cornerRadius = 8
        actionButton.layer.masksToBounds = true
    }
    
    @IBAction func buttonAction(_ sender: UIButton) {
        callBack?(sender.tag)
    }
    
    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
    }
}

extension TCSubmitButtonCell: TCCell_RowCellUpdateProtocol {
    // 是否显示按钮 按钮图标、按钮标题、按钮标题颜色、按钮宽度、边框颜色
    typealias DataSource = (Bool, String, String, UIColor, CGFloat, UIColor?)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
    func row_update(config data: TCFormCellConfigModel) {
        bgView.backgroundColor = data.bgColor
        self.backgroundColor = data.cellColor
    }
    
    
    func row_update(dataSource data: (Bool, String, String, UIColor, CGFloat, UIColor?)) {
        if !data.1.isEmpty {
            actionButton.setImage(UIImage(named: data.1), for: .normal)
        }else{
            actionButton.setImage(nil, for: .normal)
        }
        actionButton.setTitle(data.2, for: .normal)
        actionButton.setTitleColor(data.3, for: .normal)
        if let boardColor = data.5 {
            actionButton.layer.borderColor = boardColor.cgColor
            actionButton.layer.borderWidth = 1
        }else{
            actionButton.layer.borderWidth = 0
        }
    }
    
}


