//
//  TCSwitchCell.swift
//  TooneCRM
//
//  Created by fishxiaou on 2022/4/15.
//

import UIKit

class TCSwitchCell: UITableViewCell {

    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var titleLabel: UILabel!
    
    @IBOutlet weak var buttonA: UIButton!
    @IBOutlet weak var buttonAWLC: NSLayoutConstraint!
    
    @IBOutlet weak var buttonB: UIButton!
    @IBOutlet weak var buttonBWLC: NSLayoutConstraint!
    
    @IBOutlet weak var bgViewTrailingC: NSLayoutConstraint!
    @IBOutlet weak var bgViewLeadingC: NSLayoutConstraint!
    @IBOutlet weak var lineView: UIView!
    
    // 按钮内部事件
    var callBack: TCRowCallBack?
    
    override func awakeFromNib() {
        super.awakeFromNib()
        self.selectionStyle = .none
        buttonA.setImage(UIImage(named: "icon_circle"), for: .normal)
        buttonA.setImage(UIImage(named: "icon_circle_sel"), for: .selected)
        
        buttonB.setImage(UIImage(named: "icon_circle"), for: .normal)
        buttonB.setImage(UIImage(named: "icon_circle_sel"), for: .selected)
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

    }
    
    @IBAction func cellButtonAction(_ sender: UIButton) {
        callBack?(sender.tag)
    }
    
}

extension TCSwitchCell: TCCell_RowCellUpdateProtocol {
    // aTitle:String, aWidth:CGFloat, aTag:Int, bTitle:String, bWidth:CGFloat, bTag:Int, selTag:Int
    typealias DataSource = (String, CGFloat?, Int, String, CGFloat?, Int, Int)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
    func row_update(config data: TCFormCellConfigModel) {
        self.backgroundColor = data.cellColor
        bgView.backgroundColor = data.bgColor
        
        bgViewLeadingC.constant = data.bgViewLeading ?? 0
        bgViewTrailingC.constant = data.bgViewTrailing ?? 0
        
        titleLabel.textColor = data.titleColor
        titleLabel.font = data.titleFont
        if data.showTipLabel {
            let showStr = NSMutableAttributedString(string: data.titleText)
//            showStr.append(NSAttributedString(string: "*", attributes: [NSAttributedString.Key.foregroundColor : UIColor(hexString: "#F7544D")]))
            showStr.insert(NSAttributedString(string: "*", attributes: [NSAttributedString.Key.foregroundColor : UIColor(hexString: "#F7544D")]), at: 0)
            titleLabel.attributedText = showStr
        }else{
            titleLabel.text = data.titleText
        }
        lineView.isHidden = !data.showLineView
        
        buttonA.isUserInteractionEnabled = data.canEdit
        buttonB.isUserInteractionEnabled = data.canEdit
        
    
    }
    
    func row_update(dataSource data: (String, CGFloat?, Int, String, CGFloat?, Int, Int)) {
        buttonA.setTitle(" "+data.0, for: .normal)
        buttonAWLC.constant = data.1 ?? 60
        buttonA.tag = data.2
        buttonA.isSelected = data.2 == data.6
        
        buttonB.setTitle(" "+data.3, for: .normal)
        buttonBWLC.constant = data.4 ?? 60
        buttonB.tag = data.5
        buttonB.isSelected = data.5 == data.6
    }
    
}
