//
//  TCTextFieldCell.swift
//  TooneCRM
//
//  Created by fishxiaou on 2022/4/15.
//

import UIKit

class TCTextFieldCell: UITableViewCell, UITextFieldDelegate {
    
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var titleLabel: UILabel!
    @IBOutlet weak var cellTextField: UITextField!
    @IBOutlet weak var unitLab: UILabel!
    @IBOutlet weak var lineView: UIView!
    @IBOutlet weak var titleLabelWLC: NSLayoutConstraint!
    
    @IBOutlet weak var bgViewLeadingC: NSLayoutConstraint!
    @IBOutlet weak var bgViewTrailingC: NSLayoutConstraint!
    
    @IBOutlet weak var textFieldTraillingC: NSLayoutConstraint!
    // 输入限制的正则
    var RegExpText = ""
    
    // 事件
    var callBack: TCRowCallBack?

    override func awakeFromNib() {
        super.awakeFromNib()
        self.selectionStyle = .none
        cellTextField.addTarget(self, action: #selector(self.fieldChanged(theF:)), for: .editingChanged)
        cellTextField.addTarget(self, action: #selector(self.fieldChangedEnd(theF:)), for: .editingDidEnd)
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
    }
    
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        guard !RegExpText.isEmpty else {
            return true
        }
        
        if string.isEmpty {
            return true
        }
        
        let curText = textField.text ?? ""
        let endText = NSString(string: curText).replacingCharacters(in: range, with: string)
        let predicte = NSPredicate(format:"SELF MATCHES %@", RegExpText)
        return predicte.evaluate(with: endText)
    }
    
    @objc func fieldChanged(theF:UITextField)  {
        callBack?((UIControl.Event.editingChanged,theF.text ?? ""))
    }
    
    @objc func fieldChangedEnd(theF:UITextField)  {
        callBack?((UIControl.Event.editingDidEnd,theF.text ?? ""))
    }
    
}

extension TCTextFieldCell: TCCell_RowCellUpdateProtocol {
    // title宽度、value、placeholder  正则、键盘类型
    typealias DataSource = (CGFloat?,String,String,String?,UIKeyboardType?)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
    func row_update(config data: TCFormCellConfigModel) {
        bgView.backgroundColor = data.bgColor
        self.backgroundColor = data.cellColor
        titleLabel.textColor = data.titleColor
        titleLabel.font = data.titleFont
        
        cellTextField.textColor = data.infoColor
        cellTextField.font = data.infoFont
        
        bgViewLeadingC.constant = data.bgViewLeading ?? 0
        bgViewTrailingC.constant = data.bgViewTrailing ?? 0
        
        if data.showTipLabel {
            let showStr = NSMutableAttributedString(string: data.titleText)
//            showStr.append(NSAttributedString(string: "*", attributes: [NSAttributedString.Key.foregroundColor : UIColor(hexString: "#F7544D")]))
            showStr.insert(NSAttributedString(string: "*", attributes: [NSAttributedString.Key.foregroundColor : UIColor(hexString: "#F7544D")]), at: 0)
            titleLabel.attributedText = showStr
        }else{
            titleLabel.text = data.titleText
        }
        
        if data.unitText.isEmpty {
            unitLab.isHidden = true
        }else{
            textFieldTraillingC.constant = 40
            unitLab.isHidden = false
            unitLab.text = data.unitText
        }
        
        cellTextField.isUserInteractionEnabled = data.canEdit
        cellTextField.textAlignment = data.textAlignment
        lineView.isHidden = !data.showLineView
    }
    
    func row_update(dataSource data: (CGFloat?,String,String,String?,UIKeyboardType?)) {
        titleLabelWLC.constant = data.0 ?? 100
        cellTextField.text = data.1
        cellTextField.placeholder = data.2
        RegExpText = data.3 ?? ""
        cellTextField.keyboardType = data.4 ?? .default
    }
    
}
