//
//  TCTextLineCell.swift
//  Service
//
//  Created by Jan on 2023/6/13.
//  Copyright © 2023 yus. All rights reserved.
//

import UIKit

class TCTextLineCell: UITableViewCell {
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var titleLabel: UILabel!
    @IBOutlet weak var infoLabel: UILabel!
    @IBOutlet weak var lineView: UIView!
    @IBOutlet weak var titleLabelWLC: NSLayoutConstraint!
    @IBOutlet weak var rightView: UIButton!
    @IBOutlet weak var bgLeadingC: NSLayoutConstraint!
    @IBOutlet weak var bgTrailingC: NSLayoutConstraint!
    
    @IBOutlet weak var rightViewTrailingC: NSLayoutConstraint!
    @IBOutlet weak var rightViewWidthC: NSLayoutConstraint!
    override func awakeFromNib() {
        super.awakeFromNib()
        self.selectionStyle = .none
       
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
    }
    
}

extension TCTextLineCell: TCCell_RowCellUpdateProtocol {
    // value、placeholder
    typealias DataSource = (CGFloat?, String, String,CGFloat?,CGFloat?)
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(config data: TCFormCellConfigModel) {
        contentView.backgroundColor = data.bgColor
        bgView.makeLayerRadius(value: data.cornerRadius ?? 0.0, type: data.cornerMask ?? [.layerMaxXMaxYCorner,.layerMaxXMinYCorner,.layerMinXMaxYCorner,.layerMinXMinYCorner])
        
        titleLabel.textColor = data.titleColor
        titleLabel.font = data.titleFont
        titleLabel.text = data.titleText
        titleLabel.numberOfLines = data.titleNumberOfLine
        titleLabel.textAlignment = data.titleAlignment
        
        infoLabel.font = data.infoFont
        infoLabel.textColor = data.infoColor
        infoLabel.textAlignment = data.textAlignment
        infoLabel.numberOfLines = data.infoNumberOfLine
        
        lineView.isHidden = !data.showLineView
        
        if data.showNextView {
            rightView.isHidden = false
            rightViewWidthC.constant = 6
            rightViewTrailingC.constant = 10
        }else{
            rightView.isHidden = true
            rightViewWidthC.constant = 0
            rightViewTrailingC.constant = 0
        }
    }
    
    func row_update(dataSource data: (CGFloat?, String, String,CGFloat?,CGFloat?)) {
        titleLabelWLC.constant = data.0 ?? 60
        if data.1.isEmpty {
            infoLabel.text = data.2
        }else{
            infoLabel.text = data.1
        }
        
        bgLeadingC.constant = data.3 ?? 15
        bgTrailingC.constant = data.4 ?? 15
    }
    
}
