//
//  TCUISwitchCell.swift

//
//  Created by wait_ on 2022/9/28.
//

import UIKit

class TCUISwitchCell: UITableViewCell {

    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var titleLabel: UILabel!
    @IBOutlet weak var switchView: UISwitch!
    @IBOutlet weak var lineView: UIView!
    
    // 按钮内部事件
    var callBack: TCRowCallBack?
    
    override func awakeFromNib() {
        super.awakeFromNib()
        switchView.onTintColor = UIColor(hexString: "#248BF4")
        self.selectionStyle = .none
        switchView.addTarget(self, action: #selector(self.switchValueChange(sender:)), for: .valueChanged)
    }
    
    @objc func switchValueChange(sender:UISwitch) {
        callBack?(sender.isOn)
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
    }
    
}

extension TCUISwitchCell: TCCell_RowCellUpdateProtocol {
    typealias DataSource = Bool
    typealias ConfigModel = TCFormCellConfigModel
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }
    
    func row_update(config data: TCFormCellConfigModel) {
        bgView.backgroundColor = data.bgColor
        titleLabel.textColor = data.titleColor
        titleLabel.font = data.titleFont
        if data.showTipLabel {
            let showStr = NSMutableAttributedString(string: data.titleText)
            showStr.append(NSAttributedString(string: "*", attributes: [NSAttributedString.Key.foregroundColor : UIColor(hexString: "#F7544D")]))
            titleLabel.attributedText = showStr
        }else{
            titleLabel.text = data.titleText
        }
        lineView.isHidden = !data.showLineView
        
        self.backgroundColor = data.cellColor
        self.bgView.backgroundColor = data.bgColor
    }
    
    func row_update(dataSource data: Bool) {
        switchView.isOn = data
    }
    
}
