

import UIKit

class TSLeFieldCell: UITableViewCell {
    
    @IBOutlet weak var bgView: UIView!
    @IBOutlet weak var lineView: UIView!
    
    @IBOutlet weak var titleLabelWidth: NSLayoutConstraint!
    @IBOutlet weak var tipLabel: UILabel!
    @IBOutlet weak var titleLabel: UILabel!
    @IBOutlet weak var inputField: UITextField!
    @IBOutlet weak var cellButton: UIButton!
    
    @IBOutlet weak var bgViewLeadingC: NSLayoutConstraint!
    @IBOutlet weak var bgViewTrailingC: NSLayoutConstraint!
    // 24 default
    @IBOutlet weak var cellButtonWLC: NSLayoutConstraint!
    
    var canEdit = true
    var callBack: TCRowCallBack?
    
    override func awakeFromNib() {
        super.awakeFromNib()
        self.selectionStyle = .none
        titleLabel.textColor = UIColor(hexString: "#333333")
        inputField.placeholder = "请输入"
        inputField.addTarget(self, action: #selector(textFieldChanged(thef:)), for: .editingChanged)
        inputField.addTarget(self, action: #selector(textFieldEditEnd(thef:)), for: .editingDidEnd)
    }

    @IBAction func cellButtonAction(_ sender: UIButton) {
        callBack?(sender.tag)
    }
    
    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
    }
    
   @objc func textFieldChanged(thef:UITextField)  {
       callBack?(thef.text ?? "")
    }
    
    @objc func textFieldEditEnd(thef:UITextField)  {
        callBack?(99)
     }
    
}

extension TSLeFieldCell :TCCell_RowCellUpdateProtocol {
    // info, plac, buttonImage, buttonTitle, buttonWidth
    typealias DataSource = (String, String, String, String, CGFloat?,CGFloat?)
    // tip、 title、 button、line
//    typealias ConfigModel = (Bool, String, UIKeyboardType, Bool, Bool, CGFloat,Bool)
    typealias ConfigModel = TCFormCellConfigModel
    
    
    func row_update(config data: (TCFormCellConfigModel)) {
        tipLabel.isHidden = !data.showTipLabel
        titleLabel.text = data.titleText
        cellButton.isHidden = !data.showIconView
        lineView.isHidden = !data.showLineView
       
        inputField.isEnabled = data.canEdit
        canEdit = data.canEdit
        
        titleLabel.textColor = data.titleColor
        titleLabel.font = data.titleFont
        
        inputField.textColor = data.infoColor
        inputField.font = data.infoFont
        
        bgViewLeadingC.constant = data.bgViewLeading ?? 0
        bgViewTrailingC.constant = data.bgViewTrailing ?? 0
    }
    
    func row_update(dataSource data: (String, String, String, String, CGFloat?,CGFloat?)) {
        inputField.text = data.0
        inputField.placeholder = data.1
        
        cellButton.setImage(UIImage(named: data.2), for: .normal)
        cellButton.setTitle(data.3, for: .normal)
        
        if let theW = data.4 {
            cellButtonWLC.constant = theW
        }else{
            cellButtonWLC.constant = 24
        }
        
        if let theW = data.5 {
            titleLabelWidth.constant = theW
        }else{
            titleLabelWidth.constant = 60
        }
        
        
       
    }
    
    func row_update(callBack block: TCRowCallBack?) {
        callBack = block
    }

}
