//
//  JXSegmentedTitleOrdersCell.swift
//  JXSegmentedViewExample
//
//  Created by Jan on 2023/10/13.
//  Copyright © 2023 jiaxin. All rights reserved.
//

import UIKit
import JXSegmentedView

open class JXSegmentedTitleOrdersCell: JXSegmentedBaseCell {
    open var titleLabel = TWPadingLabel()
    open var btn_icon = UIButton()
    
    open override func commonInit() {
        super.commonInit()

        titleLabel.textInsets = UIEdgeInsets(top: 5, left: 15, bottom: 5, right: 15)
        titleLabel.textAlignment = .center
        titleLabel.translatesAutoresizingMaskIntoConstraints = false
        titleLabel.layer.cornerRadius = 8
        titleLabel.layer.masksToBounds = true
        contentView.addSubview(titleLabel)
        
        titleLabel.snp.makeConstraints { (make) in
            make.left.right.equalToSuperview()
            make.top.equalToSuperview().offset(8)
            make.bottom.equalToSuperview().offset(-5)
        }
        
        btn_icon = UIButton()
        contentView.addSubview(btn_icon)
        btn_icon.snp.makeConstraints { (make) in
            make.top.equalTo(self.titleLabel.snp.bottom).offset(-5)
            make.centerX.equalTo(titleLabel)
            make.height.equalTo(12)
            make.width.equalTo(12)
        }

        let centerX = NSLayoutConstraint(item: titleLabel, attribute: .centerX, relatedBy: .equal, toItem: contentView, attribute: .centerX, multiplier: 1, constant: 0)
        contentView.addConstraint(centerX)
        let centerY = NSLayoutConstraint(item: titleLabel, attribute: .centerY, relatedBy: .equal, toItem: contentView, attribute: .centerY, multiplier: 1, constant: 0)
        contentView.addConstraint(centerY)
    }

    open override func reloadData(itemModel: JXSegmentedBaseItemModel, selectedType: JXSegmentedViewItemSelectedType) {
        super.reloadData(itemModel: itemModel, selectedType: selectedType )

        guard let myItemModel = itemModel as? JXSegmentedTitleAttributeItemModel else {
            return
        }

        titleLabel.numberOfLines = myItemModel.titleNumberOfLines
        if myItemModel.isSelected && myItemModel.selectedAttributedTitle != nil {
            titleLabel.attributedText = myItemModel.selectedAttributedTitle
//            titleLabel.backgroundColor = UIColor(red: 71/255, green: 139/255, blue: 255/255, alpha: 1.0)
            titleLabel.backgroundColor = UIColor.init(hexString: "#478BFF")
            btn_icon.isHidden = false
            btn_icon.setBackgroundImage(UIImage(named: "icon_home_down"), for: .normal)
        }else {
            titleLabel.attributedText = myItemModel.attributedTitle
            titleLabel.backgroundColor = .white
            btn_icon.isHidden = true
        }
    }
}


public class TWPadingLabel: UILabel {
    var textInsets:UIEdgeInsets = UIEdgeInsets.zero
    public override func drawText(in rect: CGRect) {
        super.drawText(in: rect.inset(by: UIEdgeInsets.zero))
    }
    public override func textRect(forBounds bounds: CGRect, limitedToNumberOfLines numberOfLines: Int) -> CGRect {
        var newRect = super.textRect(forBounds: bounds.inset(by: textInsets), limitedToNumberOfLines: numberOfLines)
        newRect.origin.x += textInsets.left
        newRect.origin.y += textInsets.top
        newRect.size.width += (textInsets.left + textInsets.right)
        newRect.size.height += (textInsets.top + textInsets.bottom)
        return newRect
    }
}
