//
//  Macro.swift
//

import Foundation
import UIKit


struct StringMacro {
    // 用户/隐私协议
    static let protocolStateKey = "K_ProtocolState"
    // 类型
    static let userTypeKey = "K_UserType"
    // 账号
    static let usernameKey = "K_Username"
    // 密码
    static let passwordKey = "K_Password"
    // 企业
    static let companyKey = "K_Company"
}

/// 屏幕长度
let SCREEN_H:CGFloat = UIScreen.main.bounds.size.height ;

/// 屏幕宽度
let SCREEN_W:CGFloat = UIScreen.main.bounds.size.width ;

/// 状态栏高度
let STATUS_BAR_H:CGFloat = UIApplication.shared.statusBarFrame.size.height ;

let TAB_BAR_H:CGFloat = UIApplication.shared.statusBarFrame.size.height>20 ? 83:49 ;

//根据屏幕动态比例宽高
public func KW(width:CGFloat)->CGFloat{
    MyDimeScale.scaleW(width)
}

public func KH(height:CGFloat)->CGFloat{
    MyDimeScale.scaleH(height)
}

public func KScale(meter:CGFloat)->CGFloat{
    MyDimeScale.scale(meter)
}

var CODE_INFO = "< FILE : \(#file) , LINE : \(#line) , FUCK : \(#function) > \n" ;

var IMAGE_BUNDLE_PATH = Bundle.main.resourcePath! + "/Images.bundle" ;

func image(_ subPath:NSString ,_ imageName:NSString) -> UIImage {
    let fileName = imageName.replacingOccurrences(of: ".png", with: "")
    if let url = Bundle.main.url(forResource: "Images", withExtension: "bundle") {
        let imageBundle = Bundle(url: url)
        let theImage = UIImage(named: subPath as String+"/"+(imageName as String), in: imageBundle, compatibleWith: nil) ?? UIImage()
        return theImage
    }
    
    return UIImage(named: "Images.bundle/"+(subPath as String)+"/"+fileName) ?? UIImage()
}


/**
RGB颜色宏
*/
public func RGB1(_ r:CGFloat, _ g:CGFloat, _ b:CGFloat) -> UIColor {
    return RGBA(r, g, b, 1)
}

func RGBA(_ r:CGFloat,_ g:CGFloat,_ b:CGFloat,_ a:CGFloat) -> UIColor{
    return UIColor(red: r/255.0, green: g/255.0, blue: b/255.0, alpha: a)
}

let Line_Color:UIColor  =  RGBA(200,200,200,1.0)
let Deep_Color : UIColor = RGBA(48, 104, 92, 1.0) ;
let Shallow_Color : UIColor = RGBA(61, 132, 145, 1.0) ;
let Gray_Color : UIColor = RGBA(150,150,150,1.0) ;
let Red_Color :UIColor = RGBA(252,76,122,1.0)
let Blue_Color :UIColor = RGBA(89,194,230,1.0)
let Normal_Color :UIColor = RGBA(51,51,51,1.0)

public let KMainColour = hexColor(hex: "478BFF")//主题颜色
public let KTableViewBackgroundColor = hexColor(hex: "F8F8F8")//背景色
public let KTableViewBackgroundColor2 = hexColor(hex: "EFEFF0")//稍微深一些背景色
public let KLineColour = hexColor(hex: "E6E6E6")//分割线颜色

func hexColor(hex: String) -> UIColor {
    let scanner = Scanner(string: hex)
    scanner.scanLocation = 0
    var rgbValue: UInt64 = 0
    scanner.scanHexInt64(&rgbValue)
    let r = ((CGFloat)((rgbValue & 0xFF0000) >> 16)) / 255.0
    let g = ((CGFloat)((rgbValue & 0xFF00) >> 8)) / 255.0
    let b = ((CGFloat)(rgbValue & 0xFF)) / 255.0
    return UIColor(red: r, green: g, blue: b, alpha: 1.0)
}

/**
设置font，得到string的长度
:param: text string
:param: font font
:returns: length
*/
func getTextWidth(_ text:String ,_ font:UIFont ) -> CGFloat{
    let size = CGSize(width: CGFloat.greatestFiniteMagnitude, height: 40) ;
    let label = UILabel(frame: CGRect.zero);
    label.font = font
    label.text = text
    label.sizeToFit()
    let resultSize = label.sizeThatFits(size);
    return resultSize.width ;
}

func getTextHeight(_ text:String ,_ width:CGFloat ,_ font:UIFont ) -> CGFloat{
    let size = CGSize(width: width, height: CGFloat.greatestFiniteMagnitude) ;
    let label = UILabel(frame: CGRect(x: 0, y: 0, width: width, height: CGFloat.greatestFiniteMagnitude));
    label.text = text ;
    label.font = font
    label.numberOfLines = 0 ;
    let resultSize = label.sizeThatFits(size);
    return resultSize.height ;
}

func versionHasNew(vLoa:String, vNew:String) -> Bool {
    print(vLoa, "<==>", vNew)
    let arrLoa = vLoa.split(separator: ".")
    let arrNew = vNew.split(separator: ".")
    for (idx, item) in arrNew.enumerated() {
        let itemNew = Int(item) ?? 0
        var itemLoa = 0
        if arrLoa.count > idx {
            itemLoa = Int(arrLoa[idx]) ?? 0
        }
        if (itemNew > itemLoa) {
            return true
        }else if (itemNew < itemLoa) {
            return false
        }
    }
    return false
}

//获取服务器+url
func kGetServerPicUrl(_ url:String) -> String{
    var picUrl = ""
    if url == ""{return ""}
    picUrl = url
    if !url.contains("http"){
        picUrl = MyInfo.shareInstance().uploadServerAddress+url
    }
    
    return picUrl
}

func kGetPicUrl(_ url:String) -> String{
    return url.replacingOccurrences(of: MyInfo.shareInstance().uploadServerAddress, with: "")
}

func getCurrentLanguage() -> String {
    let defs = UserDefaults.standard
    let languages = defs.object(forKey: "AppleLanguages")
    
    var preferredLang = ""
    if let langArr = languages as? Array<String> {
        let lang = langArr.first
        preferredLang = lang ?? ""
    }
    debugPrint("当前系统语言:\(preferredLang)")
    if preferredLang.contains("en") {
        return "英文"//英文
    }else if preferredLang.contains("zh") {
        return "中文"//简体中文
    }else{
        return "其他"
    }

}

func isEnglish() -> Bool {
    let defs = UserDefaults.standard
    let languages = defs.object(forKey: "AppleLanguages")
    
    var preferredLang = ""
    if let langArr = languages as? Array<String> {
        let lang = langArr.first
        preferredLang = lang ?? ""
    }
    debugPrint("当前系统语言:\(preferredLang)")
    if preferredLang.contains("en") {
        return true//英文
    }else{
        return false
    }

}

#if DEBUG
    
    
#else
    

#endif









