//
//  UIFont+TSGeneral.m
//  TShopMall
//
//  Created by 曾亚军 on 2021/7/29.
//

#import "UIFont+TSGeneral.h"

@implementation UIFont (TSGeneral)

+ (UIFont *)ts_font:(FontType)type size:(CGFloat)size{
    return [UIFont fontWithName:[self fontName:type] size:size];
}

+ (NSString *)fontName:(FontType)fontType{
    switch (fontType) {
        case  PingFangSCMedium:
            return  @"PingFangSC-Medium";
        case PingFangSCSemibold:
            return @"PingFangSC-Semibold";
        case TclNumberBold:
            return @"TclNumber-Bold";
        case TclNumberRegular:
            return @"TclNumber-Regular";
        default:
            return @"PingFangSC-Regular";
    }
    return @"PingFangSC-Regular";
}


+ (instancetype)ts_Font:(TCLFontType)type {
    switch (type) {
        case TCLFontType30Medium:
            return [UIFont systemFontOfSize:30 weight:UIFontWeightMedium];
        case TCLFontType18Medium:
            return [UIFont systemFontOfSize:18 weight:UIFontWeightMedium];
        case TCLFontType16Medium:
            return [UIFont systemFontOfSize:16 weight:UIFontWeightMedium];
        case TCLFontType18Regular:
            return [UIFont systemFontOfSize:18];
        case TCLFontType16Regular:
            return [UIFont systemFontOfSize:16];
        case TCLFontType14Regular:
            return [UIFont systemFontOfSize:14];
        case TCLFontType14:
            return [UIFont systemFontOfSize:14];
        case TCLFontType13:
            return [UIFont systemFontOfSize:13];
        case TCLFontType12:
            return [UIFont systemFontOfSize:12];
        case TCLFontType10:
            return [UIFont systemFontOfSize:10];
        case TCLFontType8:
            return [UIFont systemFontOfSize:8];
    }
}
@end
