//
//  TWOCNetwork.h
//  TWOCNetwork
//
//  Created by fishxiaou on 2022/7/20.
//

#import <Foundation/Foundation.h>
#import "TWOCNetManager.h"
NS_ASSUME_NONNULL_BEGIN

// 成功、返回字典
typedef void(^successBlock)(NSDictionary *);
// 错误、返回错误码、错误内容
typedef void(^failBlock)(int, NSString *);
// 上传等操作 进度回传
typedef void(^progressBlock)(CGFloat);

/// 数据请求
@interface TWOCNetwork : NSObject

// 基础参数
@property(nonatomic,copy)NSString *token;
@property(nonatomic,copy)NSString *baseURL;
@property(nonatomic,copy)NSString *filePath;
@property(nonatomic,copy)NSString *businessFilePath;
@property(nonatomic,assign,getter=isJsonContentType)BOOL jsonContentType;
@property(nonatomic,assign,getter=isLog)BOOL log;
@property(nonatomic,strong)NSDictionary *baseParameters;
@property(nonatomic,strong)NSDictionary<NSString *,NSString *> *HTTPHeaders;

// 请求参数
@property(nonatomic,assign)NSInteger pageNo;                 // 页码
@property(nonatomic,assign)NSInteger pageSize;               // 页数
@property(nonatomic,copy)NSString *requestUrl;               // 请求
@property(nonatomic,strong)NSDictionary *parameters;  // 参数
@property(nonatomic,strong)NSDictionary<NSString *, NSArray<NSString *> *> *formDataParameters;  // 参数

// 结果回调
@property(nonatomic,strong)successBlock successCall;
@property(nonatomic,strong)failBlock failCall;
@property(nonatomic,strong)progressBlock progressCall;

// 初始化全局静态变量\基础请求单例
+(TWOCNetManager *) shareNetManager;

// 初始化
-(instancetype)initUrl:(NSString *)reqUrl andParam:(NSDictionary *)reqParam;
// 初始化 表格要传数组时 formDataParam内value为NSString类型
-(instancetype)initUrl:(NSString *)reqUrl andParam:(NSDictionary *)reqParam formDataParam:(NSDictionary<NSString *, NSArray<NSString *> *> *)formDataParam;

// Post请求
-(void)postRequest;
// Get请求
-(void)GetRequest;

/// 登录
-(void)sendConfigRequest;
/// 注册
- (void)sendRegisterRequest;

// 文件 上传\下载
-(void)upLoadFile:(NSString *)localPath;
-(void)downLoadFile:(NSString *)fileUrl;
// 图片
-(void)upLoadImage:(UIImage *)upImage;
-(void)upLoadFile:(NSData *)data
         fileName:(NSString *)fileName
          isImage:(BOOL)isImage;

@end

NS_ASSUME_NONNULL_END
