
Pod::Spec.new do |s|
  s.name             = 'Utility'
  s.version          = '0.1.0'
  s.summary          = 'A 本地资源.'
  s.description      = <<-DESC
  TODO: A 本地资源，项目配置，通用组件.
                       DESC

  s.homepage         = 'https://github.com/liucaide'
  #s.license          = { :type => 'MIT', :file => 'LICENSE' }
  s.author           = { 'liucaide' => '565726319@qq.com' }
  s.source           = { :git => '' }
  # s.social_media_url = 'https://twitter.com/<TWITTER_USERNAME>'

  s.ios.deployment_target = '9.0'
  s.swift_version = ['4.0', '4.2', '5.0']

  s.default_subspec = 'Core'
  
  s.subspec 'Core' do |core|
    core.dependency 'Utility/User'
    core.dependency 'Utility/Web'
    core.dependency 'Utility/HUD'
    core.dependency 'Utility/Config'
    core.dependency 'Utility/Net'
    core.dependency 'Utility/Assets'
    core.dependency 'Utility/Extension'
    core.dependency 'Utility/Crypto'
    core.dependency 'Utility/Views'
    core.dependency 'Utility/Menus'
    core.dependency 'Utility/Models'
    #core.dependency 'Utility/FileManager'
  end

  # 用户信息管理、登录注册响应模型
  s.subspec 'User' do |user|
    user.source_files = 'Utility/User/**/*'
    user.dependency 'KeychainAccess', '~> 3.2.0'
    user.dependency 'CaamDau'
  end

  # 提示窗
  s.subspec 'HUD' do |hud|
    hud.source_files = 'Utility/HUD/**/*'
    hud.dependency 'CaamDau/HUD'
  end

  # 提示窗
  s.subspec 'Web' do |web|
    web.source_files = 'Utility/Web/**/*'
    web.dependency 'CaamDau/TopBar'
  end

  # 全局基本配置
  s.subspec 'Config' do |config|
    config.source_files = 'Utility/Config/Classes/**/*'
    config.resource_bundles = {
      'Config' => ['Utility/Config/Assets/*.{plist,xcassets}']
    }
    config.dependency 'CaamDau'
  end
  
  # 全局基本配置
#  s.subspec 'FileManager' do |fm|
#    config.source_files = 'Utility/FileManager/FileManager/**/*', 'Utility/FileManager/TWDocumentVC/**/*'
#    config.resource = 'Utility/FileManager/TWDocFileIcon/*.{png}'
#    config.dependency 'CaamDau'
#  end

  # 网络基本配置
  s.subspec 'Net' do |net|
    net.source_files = 'Utility/Net/Classes/**/*'
    net.resource_bundles = {
      'UtilityNet' => ['Utility/Net/Assets/*.cer']
    }
    net.dependency 'CaamDau/Net/All'
  end

  # 通用实施扩展 - ImageView Button ... 
  s.subspec 'Extension' do |ex|
    ex.source_files = 'Utility/Extension/**/*'
    ex.dependency 'CaamDau/Core'
    ex.dependency 'CaamDau/Net/All'
    ex.dependency 'Kingfisher','4.10.1'
    ex.dependency 'TZImagePickerController'
    ex.dependency 'Utility/PhotoBrowser'
  end

  # 图片浏览器
  s.subspec 'PhotoBrowser' do |pb|
    pb.source_files = 'JXPhotoBrowser/**/*'
    pb.dependency 'CaamDau/Core'
    pb.dependency 'CaamDau/IconFont'
    pb.dependency 'Kingfisher'
  end
  
  
  # 加密
  s.subspec 'Crypto' do |crypto|
    crypto.source_files = 'Utility/Crypto/**/*'
    #crypto.dependency 'CryptoSwift', '0.15.0'
  end

  # 通用图片资源
  s.subspec 'Assets' do |ass|
    ass.source_files = 'Utility/Assets/Classes/**/*'
    ass.resource_bundles = {
      'Assets' => ['Utility/Assets/Assets/*.{xcassets}']
    }
    ass.dependency 'CaamDau'
  end
  
  # 通用View资源
  s.subspec 'Views' do |vv|
    vv.source_files = 'Utility/Views/Classes/**/*'
    vv.resource_bundles = {
      'UtilityViews' => ['Utility/Views/Nib/*.{xib}']
    }
    vv.dependency 'CaamDau'
  end
  
  # 通用弹窗菜单资源
  s.subspec 'Menus' do |menus|
    menus.source_files = 'Utility/Menus/Classes/**/*'
    menus.resource_bundles = {
      'UtilityMenus' => ['Utility/Menus/Nib/*.{xib,storyboard}']
    }
    menus.dependency 'CaamDau'
    menus.dependency 'IQKeyboardManagerSwift'
  end
  
  # 通用Model资源
  s.subspec 'Models' do |mm|
    mm.source_files = 'Utility/Models/**/*'
    mm.dependency 'CaamDau'
  end
  
  # 通用图片资源
  s.subspec 'AssetsTest' do |asstest|
    asstest.source_files = 'Utility/AssetsTest/Classes/**/*'
    asstest.resource_bundles = {
      'AssetsTest' => ['Utility/AssetsTest/Assets/*.{xcassets}']
    }
    asstest.dependency 'CaamDau'
  end

  # 导航、Tab 图片资源
  # s.subspec 'TabAssets' do |tabass|
  #   tabass.source_files = 'Utility/TabAssets/Classes/**/*'
  #   tabass.resource_bundles = {
  #     'TabAssets' => ['Utility/TabAssets/Assets/*.{xcassets}']
  #   }
  #   tabass.dependency 'CaamDau/Extension'
  # end

  # 购物车、商品详情、订单、图片资源
  # s.subspec 'CartAssets' do |carass|
  #   carass.source_files = 'Utility/CartAssets/Classes/**/*'
  #   carass.resource_bundles = {
  #     'CartAssets' => ['Utility/CartAssets/Assets/*.{xcassets}']
  #   }
  #   carass.dependency 'CaamDau/Extension'
  # end

  # 个人中心资源
  # s.subspec 'MineAssets' do |mineass|
  #   carass.source_files = 'Utility/MineAssets/Classes/**/*'
  #   carass.resource_bundles = {
  #     'MineAssets' => ['Utility/MineAssets/Assets/*.{xcassets}']
  #   }
  #   carass.dependency 'CaamDau/Extension'
  # end
end
