//Created  on 2019/6/20 by  LCD:https://github.com/liucaide .

/***** 模块文档 *****
 *
 */




import Foundation
import CaamDau
import Kingfisher
//import SDWebImage

public extension CaamDau where Base: CD_TopBar {
    @discardableResult
    func backWhite() -> [CD_TopNavigationBarItem.Item.Style] {
        let icon = CD_IconFont.tback_light(22)
        return [.title([(icon.text, icon.font, UIColor.white, .normal), (icon.text, icon.font, UIColor.white.cd_alpha(0.6), .highlighted), (icon.text, icon.font, UIColor.white.cd_alpha(0.6), .selected)])]
    }
    
    @discardableResult
    func backBlack() -> [CD_TopNavigationBarItem.Item.Style] {
        let icon = CD_IconFont.tback_light(22)
        return [.title([(icon.text, icon.font, Config.color.txt_1, .normal), (icon.text, icon.font, Config.color.txt_1.cd_alpha(0.6), .highlighted), (icon.text, icon.font, Config.color.txt_1.cd_alpha(0.6), .selected)])]
    }
    
    /// 导航栏渐变色统一配置
    @discardableResult
    func gradient(_ alpha:CGFloat = 1) -> CaamDau {
        base._colorTitle = .white
        base._colorSubTitle = .white
        base._colorPrompt = .white
        base._colorNormal = .white
        base._colorSelected = UIColor.white.cd_alpha(0.6)
        base._colorHighlighted = UIColor.white.cd_alpha(0.6)
        base.bar_navigation.line.isHidden = true
        base.cd
            .background(.clear)
            .gradient(layerAxial: [(Config.color.navigation0.cd_alpha(alpha),0.floatValue), (Config.color.navigation1.cd_alpha(alpha),1.floatValue)])
        
        return self
    }
    
    /// 导航栏白色配置
    @discardableResult
    func white() -> CaamDau {
        base._colorTitle = Config.color.txt_1
        base._colorSubTitle = Config.color.txt_1
        base._colorPrompt = Config.color.txt_1
        base._colorNormal = Config.color.txt_1
        base._colorSelected = Config.color.txt_3
        base._colorHighlighted = Config.color.txt_3
        base.bar_navigation.line.isHidden = false
        base.cd.background(.white)
        return self
    }
    
    @discardableResult
    func snp() -> CaamDau {
        base.snp.makeConstraints { (make) in
            make.left.right.top.equalToSuperview()
        }
        return self
    }
    @discardableResult
    func title(_ t:String = "") -> CaamDau {
        base._title = t
        return self
    }
}




public extension CaamDau where Base: UIButton {
    @discardableResult
    func setImage(_ urlString:String, for state: UIControl.State = .normal, placeholder:UIImage? = Config.placeholder.imgBig, processor:Bool = false,  loading:Bool = false, completion:((CGSize)->Void)? = nil) -> CaamDau {
        
        var options:KingfisherOptionsInfo = [.transition(.fade(0.15))]
//        if processor {
//            let processor = DownsamplingImageProcessor(size: CGSize(w: base.frame.size.width*3, h: base.frame.size.height*3))
//            options.append(.processor(processor))
//        }
//        if loading {
//            base.cd.loading(bgViewFrame:base.bounds)
//        }
        base.kf.setImage(with: urlString.urlValue, for: state, placeholder: placeholder, options: options, progressBlock: { (i, j) in
            
        })/* { [weak base]result in
            if loading {
                base?.cd.loadingHidden()
            }
            switch result {
            case .success(let value):
                completion?(value.image.size)
            case .failure(let error):
                break
            }
        }*/
        return self
    }
    @discardableResult
    func setBgImage(_ urlString:String, for state: UIControl.State = .normal, placeholder:UIImage? = Config.placeholder.imgBig, processor:Bool = false,  loading:Bool = false, completion:((CGSize)->Void)? = nil) -> CaamDau {
        
        var options:KingfisherOptionsInfo = [.transition(.fade(0.15))]
//        if processor {
//            let processor = DownsamplingImageProcessor(size: CGSize(w: base.frame.size.width*3, h: base.frame.size.height*3))
//            options.append(.processor(processor))
//        }
//        if loading {
//            base.cd.loading(bgViewFrame:base.bounds)
//        }
        base.kf.setBackgroundImage(with: urlString.urlValue, for: state, placeholder: placeholder, options: options, progressBlock: { (i, j) in
            
        }) /*{ [weak base]result in
            if loading {
                base?.cd.loadingHidden()
            }
            switch result {
            case .success(let value):
                completion?(value.image.size)
            case .failure(let error):
                break
            }
            
        }*/
        return self
    }
}


public extension CaamDau where Base: UIImageView {
    @discardableResult
    func setImage(_ urlString:String, placeholder:UIImage? = Config.placeholder.imgBig, processor:Bool = false,  loading:Bool = true, completion:((CGSize)->Void)? = nil) -> CaamDau {
        /*/base.sd_setImage(with: urlString.urlValue, placeholderImage: placeholder, options: .scaleDownLargeImages)
        var options:KingfisherOptionsInfo = [.transition(.fade(0.15))]
        if processor {
            let processor = DownsamplingImageProcessor(size: CGSize(w: base.frame.size.width*3, h: base.frame.size.height*3))
            options.append(.processor(processor))
        }
        if loading {
            base.kf.indicatorType = .activity
        }
        base.kf.setImage(with: urlString.urlValue, placeholder: placeholder, options: options, progressBlock: { (i, j) in
            
        }) { [weak base]result in
            switch result {
            case .success(let value):
                completion?(value.image.size)
            case .failure(let error):
                break
            }
            
        }*/
        return self
    }
}
