//Created  on 2019/9/17 by  LCD:https://github.com/liucaide .

/***** 模块文档 *****
 *
 */




import Foundation
import CaamDau
import SwiftyJSON


public enum TWCrypto:String {
    case rsa = "rsa"
    case none = "none"
    
    case privateKey = "privateKey"
}
public extension TWCrypto {
    func encrypt(_ value:String) -> String {
        switch self {
        case .rsa:
            let key = self.string ?? "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCHneoAxOnidZwXPbUkIx5RIhNW1lo9163H2PYgfS9+yF/89Gj80EFQwAxQHBwUkTQjyVm+d8ABY30+qFFoZcPr8Pcx9fMG1MihMZGlvsX6CpwFsp0pv+OKUW9Nd797AxqNm18hFF5rcAEXakATKFBsuVlo/86pHpfHKy9QL1xeOwIDAQAB"
            return Crypto_RSA.encryptString(value, publicKey: key)
        default:
            return value
        }
    }
    
    func updatePublickey(){
        var url = ""
        switch self {
        case .rsa:
            url = "/m/login/get_rsa_code.jhtml"
        default:
            return
        }
        
        CD_Net()
            .path("/m/login/get_rsa_code.jhtml")
            .mapJSON({ (json) in
                self.save(json["public_key"].stringValue)
                
                TWCrypto.privateKey.save(json["private_key"].stringValue)
            })
            .request()
    }
}

extension TWCrypto: CaamDauUserDefaultsProtocol {
    public var name: String {
        return "crypto_publickey_" + self.rawValue
    }
}

public extension String {
    func tw_encrypt(_ type:TWCrypto) -> String {
        return type.encrypt(self)
    }
}
