//Created  on 2019/8/22 by  LCD:https://github.com/liucaide .

/***** 模块文档 *****
 *
 */




import Foundation
import CaamDau
import Photos

public class TWPhotoBrowser {
    
    
    public static func show(_ images:[Any], index:UInt = 0) {
        guard let images = images as? [String]  else {
            return
        }
        // 网图加载器
        let loader = JXKingfisherLoader()
        // 数据源
        let dataSource = JXNetworkingDataSource(photoLoader: loader, numberOfItems: { () -> Int in
            return images.count
        }, placeholder: { index -> UIImage? in
            return nil
        }) { index -> String? in
            return images[index]
        }
        // 视图代理，实现了数字型页码指示器
        let delegate = JXDefaultPageControlDelegate()
        // 长按事件
        delegate.longPressedCallback = { browser, index, image, gesture in
            guard let image = image else { return }
            longPressed(image)
        }
        // 打开浏览器
        let browser = JXPhotoBrowser(dataSource: dataSource, delegate: delegate)
        browser.show(pageIndex: Int(index))
       
    }
    
    static func longPressed(_ image:UIImage) {
        func save() {
            DispatchQueue.global().async {
                PHPhotoLibrary.shared().performChanges({
                    PHAssetChangeRequest.creationRequestForAsset(from: image)
                }) { (bool, error) in
                    DispatchQueue.main.async {
                        hud_msg(bool ? "保存成功" : "保存失败")
                    }
                }
            }
        }
        
        func alert() {
            UIAlertController.cd_init(style: .actionSheet).cd
            .action("取消", style: .cancel)
            .action("保存到相册", handler: { (a) in
                save()
            })
            .show()
        }
        
        alert()
    }
    
    
    
    
    /*
    public static func showMW(_ images:[Any], index:UInt = 0){
        let photos = images.compactMap { (item) -> MWPhoto? in
            switch item {
            case let img as UIImage:
                return MWPhoto(image: img)
            case let str as String:
                return MWPhoto(url: str.urlValue)
            case let url as URL:
                return MWPhoto(url: url)
            default:
                return MWPhoto(image: UIImage())
            }
            
        }
        guard let browser = MWPhotoBrowser(photos: photos) else {
            return
        }
        // 设置可选项
        // 是否展示允许分享，复制等操作项按钮，默认是YES
        browser.displayActionButton = false
        // 是否在工具栏展示左右导航箭头，默认为NO
        browser.displayNavArrows = false
        // 是否在每张照片上展示选择按钮，默认为NO
        browser.displaySelectionButtons = false
        //即将填满屏幕的图片会被缩放至填满，默认YES
        browser.zoomPhotosToFill = true
        //控制条和控件是否始终可见，或者是否在全图展示时隐去，默认NO
        browser.alwaysShowControls = false
        // 是否允许网格缩略图视图，默认YES
        browser.enableGrid = true
        // 是否以缩略图网格开始，而不是第一张图片，默认NO
        browser.startOnGrid = false
        // 设置当前可见图片索引
        
        CD.push(browser)
        // 操作设置
        browser.showNextPhoto(animated: true)
        browser.showPreviousPhoto(animated: true)
        browser.setCurrentPhotoIndex(index)
    }*/
}

