//Created  on 2019/10/30 by  LCD:https://github.com/liucaide .

/***** 模块文档 *****
 *
 */




import UIKit
import CaamDau
import IQKeyboardManagerSwift
public struct R_PopupInput {
    public static func show(title:String, placeholder:String, submit:String, colorSubmit:UIColor = Config.color.enabledTrue, callback:((String, ((Bool)->Void)?)->Void)? = nil) {
        
        let vc = VC_PopupInput.cd_storyboard("UtilityMenusStoryboard", from: "UtilityMenus") as! VC_PopupInput
        vc.txtTitle = title
        vc.txtPlaceholder = placeholder
        vc.txtSubmit = submit
        vc.colorSubmit = colorSubmit
        vc.callback = callback
        vc.modalTransitionStyle = .crossDissolve
        vc.modalPresentationStyle = .custom
        CD.present(vc, animated: false)
    }
}

class VC_PopupInput: UIViewController {
    @IBOutlet weak var text_view: CD_TextView!
    @IBOutlet weak var btn_ok: UIButton!
    @IBOutlet weak var btn_close: UIButton!
    @IBOutlet weak var lab_title: UILabel!
    var callback:((String, ((Bool)->Void)?)->Void)?
    
    var txtTitle:String = "回复"
    var txtPlaceholder:String = "请输入"
    var txtSubmit:String = "确认"
    var colorSubmit:UIColor = Config.color.enabledTrue
    
    override func viewDidLoad() {
        super.viewDidLoad()
        makeUI()
    }
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(animated)
        IQKeyboardManager.shared.enable = true
        text_view.textView.becomeFirstResponder()
    }
    
    override func viewDidDisappear(_ animated: Bool) {
        super.viewDidDisappear(animated)
        IQKeyboardManager.shared.enable = false
    }
    
    @IBAction func closeClick(_ sender: UIButton) {
        self.dismiss(animated: true, completion: nil)
    }
    
    @IBAction func submitClick(_ sender: UIButton) {
        self.view.endEditing(true)
        callback?(text_view.text) { [weak self] animated in
            self?.dismiss(animated: animated, completion: nil)
        }
    }
}

extension VC_PopupInput {
    func makeUI() {
        self.view.cd.background(UIColor.black.cd_alpha(0.3))
        btn_close.cd
            .text(Config.color.txt_2)
            .text(CD_IconFont.tclose_light(20).text)
            .text(CD_IconFont.tclose_light(20).font)
        btn_ok.cd
            .text(txtSubmit)
            .text(Config.font.font(18))
            .corner(2, clips: true)
            .isUser(false)
            .background(Config.color.enabledFalse)
        
        lab_title.cd
            .text(txtTitle)
            .text(Config.color.txt_1)
            .text(Config.font.fontMedium(18))
        
        text_view.placeholder = txtPlaceholder
        text_view.font = Config.font.font(14)
        text_view.textColor = Config.color.txt_1
        text_view.cd
            .border(Config.color.line_1)
            .background(Config.color.bg)
        
        text_view.blockEditing = { [weak self](t, e) in
            switch e {
            case .editingChanged:
                var txt:String = t.text
                txt = txt.trimmingCharacters(in: CharacterSet.whitespacesAndNewlines)
                self?.btn_ok.cd.isUser(!txt.isEmpty)
                    .background(!txt.isEmpty ? self!.colorSubmit : Config.color.enabledFalse)
            default:
                break
            }
        }
        
        
        
    }
}
