//Created  on 2019/8/14 by  LCD:https://github.com/liucaide .

/***** 模块文档 *****
 *
 */




import UIKit
import CaamDau

public class Cell_SelectSheet: UITableViewCell {
    @IBOutlet weak var lab_left: UILabel!
    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var lab_right: UILabel!
    @IBOutlet weak var view_line: UIView!
    
    override public func awakeFromNib() {
        super.awakeFromNib()
        lab_right.cd
            .text(CD_IconFont.tcheck(20).font)
            .text(CD_IconFont.tcheck(20).text)
            .text(Config.color.main_1)
        lab_title.cd
            .text(Config.font.font(17))
            .text(Config.color.txt_1)
        view_line.cd.background(Config.color.line_1)
    }

}

extension Cell_SelectSheet: CD_RowCellUpdateProtocol {
    public typealias ConfigModel = (Bool, Bool, Bool, Bool)
    
    public typealias DataSource = (String, NSTextAlignment)
    
    public func row_update(config data: (Bool, Bool, Bool, Bool)) {
        lab_title.cd
            .text(data.0 ? Config.font.fontMedium(17) : Config.font.font(17))
            .text(data.0 ? Config.color.main_1 : Config.color.txt_1)
        
        lab_left.cd.isHidden(data.1)
        lab_right.cd.isHidden(data.2)
        view_line.cd.isHidden(data.3)
    }
    public func row_update(dataSource data: (String, NSTextAlignment)) {
        lab_title.cd
            .text(data.0)
            .text(data.1)
    }
}
