//Created  on 2019/8/14 by  LCD:https://github.com/liucaide .

/***** 模块文档 *****
 *
 */




import UIKit
import CaamDau
import Utility

public struct R_SelectSheet: CD_RowVCProtocol {
    public var vc: UIViewController {
        return VC_SelectSheet.cd_storyboard("UtilityMenusStoryboard", from: "UtilityMenus")!
    }
    
    public static func show(_ vm:VM_SelectSheet, title:String) {
        let vc = R_SelectSheet().vc as! VC_SelectSheet
        vc.modalTransitionStyle = .crossDissolve
        vc.modalPresentationStyle = .custom
        vc.title = title
        vc.vm = vm
        CD.present(vc)
    }
}

class VC_SelectSheet: UIViewController {
    @IBOutlet weak var stack_view: UIStackView!
    @IBOutlet weak var tableView: UITableView!
    @IBOutlet weak var tableView_H: NSLayoutConstraint!
    @IBOutlet weak var view_line: UIView!
    @IBOutlet weak var btn_close: UIButton!
    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var btn_submit: UIButton!
    @IBOutlet weak var safa_B: NSLayoutConstraint!
    var vm:VM_SelectSheet?
    var delegateData:CD_TableViewDelegateDataSource?
    override func viewDidLoad() {
        super.viewDidLoad()
        
        view_line.cd.background(Config.color.bg)
        lab_title.cd
            .text(self.title)
            .text(Config.color.txt_1)
            .text(Config.font.fontMedium(17))
        
        btn_close.cd
            .text(CD_IconFont.tclose(20).text)
            .text(CD_IconFont.tclose(20).font)
            //.text("取消")
            .text(Config.color.txt_3)
            //.text(Config.font.font(17))
        if #available(iOS 11.0, *) {
            if let b = CD.window?.safeAreaInsets.bottom, b > 0 {
                safa_B.constant = b
            }else{
                safa_B.constant = 0
            }
        } else {
            safa_B.constant = 0
        }
        
        delegateData = CD_TableViewDelegateDataSource(vm)
        tableView.cd
            .background(Config.color.bg)
            .delegate(delegateData)
            .dataSource(delegateData)
        tableView_H.constant = vm?.tableViewHeight ?? 50
        vm?.reloadData = { [weak self] in
            self?.tableView_H.constant = self?.vm?.tableViewHeight ?? 50
            self?.tableView.reloadData()
        }
        
        vm?.dismisCallback = {[weak self] in
            self?.dismis()
        }
        
        
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        addAnimation(with: stack_view, remove:false)
    }
    
    @IBAction func buttonClick(_ sender: UIButton) {
        switch sender {
        case btn_submit:
            vm?.submitClick()
        default:
            vm?.removeClick()
        }
        dismis()
    }
    
    func dismis(){
        
        addAnimation(with: stack_view, remove:true)
        self.dismiss(animated: true, completion: nil)
    }
    
    func addAnimation(with view: UIView, remove:Bool){
        view.superview?.layoutIfNeeded()
        let value0 = view.layer.position.y + tableView_H.constant + 50 + 10 + safa_B.constant
        let value1 = view.layer.position.y
        
        let animote = CABasicAnimation(keyPath: "position.y")
        animote.duration = 0.25
        animote.isRemovedOnCompletion = false
        animote.fillMode = .forwards
        animote.fromValue = remove ? value1 : value0
        animote.toValue = remove ? value0 : value1
        animote.timingFunction = CAMediaTimingFunction(name: .easeOut)
        view.layer.add(animote, forKey: animote.keyPath)
    }
}
