//Created  on 2019/11/14 by  LCD:https://github.com/liucaide .

/***** 模块文档 *****
 *
 */




import Foundation
import CaamDau
import SwiftyJSON

public struct M_Coupon {
    public init(){}
    public var id = ""
    public var code = ""
    public var code_id = ""
    public var price = ""
    public var condition = ""
    public var title = ""
    public var store:Store = Store()
    public var timeStart = ""
    public var timeEnd = ""
    public var explain = ""
    public var count = 0
    // 是否已领取
    public var isGet:Bool?
    
    public var status:Status = .none
    
    public enum Flag: CD_SwiftyJSONTagProtocol {
        case get
        case list
        case select
    }
}

extension M_Coupon: CD_SwiftyJSONProtocol {
    public init(_ json: JSON, tag: CD_SwiftyJSONTagProtocol?) {
        id = json["coupon_id"].stringValue
        code = json["code"].stringValue
        code_id = json["coupon_code_id"].stringValue
        price = json["coupon_discount_price"].stringValue
        condition = "满"+json["min_price_usable"].stringValue+"元可用"
        title = json["coupon_name"].stringValue
        timeStart = json["coupon_begin_date"].stringValue
        timeEnd = json["coupon_end_date"].stringValue
        explain = json["coupon_introduction"].stringValue
        count = json["total_count"].intValue
        
        store = Store(json, tag: tag)
        
        let is_notget = json["is_notget"].int
        isGet = is_notget?.boolValue ?? nil
        
        let isused = json["coupon_isused"].int
        if isused != nil {
            status = isused!.boolValue ? .used : .unused
        }
        let hasexpired = json["coupon_hasexpired"].int
        if hasexpired != nil, hasexpired!.boolValue {
            status = .expired
        }
        
        guard let tag = tag as? Flag else {
            return
        }
        switch tag {
        case .get:
            isGet = json["is_notget"].boolValue ?? nil
        default:
            break
        }
    }
}

extension M_Coupon {
    public enum Status {
        case unused
        case used
        case expired
        case none
        
        public var flag:Int {
            switch self {
            case .unused:
                return 2
            case .used:
                return 3
            case .expired:
                return 4
            case .none:
                return -1
            }
        }
        public var title:String {
            switch self {
            case .unused:
                return "未使用"
            case .used:
                return "已使用"
            case .expired:
                return "已过期"
            case .none:
                return ""
            }
        }
        
        public var icon:UIImage? {
            switch self {
            case .unused:
                return nil
            case .used:
                return nil
            case .expired:
                return nil
            case .none:
                return nil
            }
        }
    }
    
    public struct Store: CD_SwiftyJSONProtocol {
        public var id = ""
        public var name = ""
        public init(){}
        public init(_ json: JSON, tag: CD_SwiftyJSONTagProtocol?) {
            id = json["company_info_id"].stringValue
            name = json["company_name"].stringValue
        }
    }
}
