//Created  on 2019/7/10 by  LCD:https://github.com/liucaide .

/***** 模块文档 *****
 *
 */




import Foundation
import CaamDau
import SwiftyJSON

extension M_Goods {
    public enum UserDefaults:String {
        case imagesSize = "imagesSize"
    }
}
extension M_Goods.UserDefaults: CaamDauUserDefaultsProtocol {
    public var name: String {
        return "goods.userDefaults."+self.rawValue
    }
}

//MARK:--- 商品 ----------
public struct M_Goods {
    public init() {}
    public var id:String = ""
    public var store:Store = Store()
    public var goods:Goods = Goods()
    public var activity:Activity = Activity()
    
    
    public struct Store {
        public var id = ""
        public var name = ""
    }
    
    public struct Goods {
        public var id:String = ""
        public var code:String = ""
        public var icon:String = ""
        public var name:String = ""
        public var fullname:String = ""
        public var price1:String = "0.00"
        public var price2:String = "0.00"
        public var price3:String = "0.00"
        public var item_model = ""
        /// 库存
        public var inventory:Int = 10000
        /// 图片列表
        public var images:[M_Goods.Images] = []
        /// 是否已收藏
        public var isFavorite:Bool = false
        
        public var iconheight:CGFloat = CD.screenW
        
        public var _iconheight:CGFloat {
            guard let c = M_Goods.UserDefaults.imagesSize.value as? [String:String] else{
                return Config.fit.fit(132)
            }
            guard let cc = c[icon] else{
                return Config.fit.fit(132)
            }
            guard !cc.isEmpty else{
                return Config.fit.fit(132)
            }
            guard CGFloat(cc.floatValue) > 0 else{
                return Config.fit.fit(132)
            }
            let hh = (CD.screenW-Config.fit.fit(11))/CGFloat(cc.floatValue)
            return hh
        }
    }
    
    public struct Activity {
        public enum ActType:Int {
            case none = 0
            case t样机
            case t秒杀
            case t拼团
            case t折扣
        }
        
        /// 活动类型
        public var type:ActType = .none
        
        /// 活动说明
        public var explain:String = ""
        
        /// 折扣
        public var discount:String = ""
    }
    
    
    public struct Images: CD_SwiftyJSONProtocol {
        public init(_ json: JSON, tag: CD_SwiftyJSONTagProtocol?) {
            small = json["thumbnail"].stringValue
            order = json["order"].stringValue
            source = json["source"].stringValue
            big = json["large"].stringValue
            medium = json["medium"].stringValue
            image = json["image"].stringValue
        }
        public var image = ""
        public var small = ""
        public var big = ""
        public var medium = ""
        public var order = ""
        public var source = ""
        
        public var height:CGFloat = CD.screenW
        
        public var _height:CGFloat {
            guard let c = M_Goods.UserDefaults.imagesSize.value as? [String:String] else{
                return CD.screenW
            }
            guard let cc = c[image] else{
                return CD.screenW
            }
            guard !cc.isEmpty else{
                return CD.screenW
            }
            guard CGFloat(cc.floatValue) > 0 else{
                return CD.screenW
            }
            let hh = CD.screenW/CGFloat(cc.floatValue)
            return hh
        }
    }
    
    public enum Tags:CD_SwiftyJSONTagProtocol {
        case list
        case discount
        case detail
        case searchStore
    }
    
}

extension M_Goods: CD_SwiftyJSONProtocol {
    public init(_ json: JSON, tag: CD_SwiftyJSONTagProtocol?) {
        id = json["productid"].stringValue
        store = Store(json, tag: tag)
        goods = Goods(json, tag: tag)
    }
}


extension M_Goods.Store: CD_SwiftyJSONProtocol {
    public init(_ json: JSON, tag: CD_SwiftyJSONTagProtocol?) {
        id = json["companyinfoid"].stringValue
        name = json["company_name"].stringValue
        
        guard let tag = tag as? M_Goods.Tags else {
            return
        }
        switch tag {
        case .searchStore:
            id = json["company_id"].stringValue
        default:
            break
        }
    }
}
extension M_Goods.Activity: CD_SwiftyJSONProtocol {
    public init(_ json: JSON, tag: CD_SwiftyJSONTagProtocol?) {
        type = ActType(rawValue: json["active_type"].intValue) ?? .none
        /// 活动说明
        explain = json["explain"].stringValue
        /// 折扣
        discount = json["discount"].stringValue
    }
}

extension M_Goods.Goods: CD_SwiftyJSONProtocol {
    public init(_ json: JSON, tag: CD_SwiftyJSONTagProtocol?) {
        id = json["productid"].stringValue
        code = json["vonder_code"].stringValue
        icon = json["image"].stringValue
        name = json["name"].stringValue
        fullname = json["fullname"].stringValue
        price1 = json["price"].stringValue
        price2 = json["active_price"].stringValue
        price3 = json["factory_price"].stringValue
        item_model = json["item_model"].stringValue
        // - 详情
        images = json["image_list"].arrayValue.compactMap{M_Goods.Images($0, tag: nil)}
    }
}
