//Created  on 2019/7/10 by  LCD:https://github.com/liucaide .

/***** 模块文档 *****
 * 公共
 */

import CaamDau
import SwiftyJSON

//import PGPay

//MARK:--- 公用类型 ----------
public enum PayType:Int {
    case ali = 0
    case wx
    case union
    case balance
    case none
    
    
    public var title:String {
        switch self {
        case .ali:
            return "支付宝支付"
        case .wx:
            return "微信支付"
        case .union:
            return "银联支付"
        case .balance:
            return "余额支付"
        default:
            return ""
        }
    }
    
    public var icon:UIImage? {
        switch self {
        case .ali:
            return nil
        case .wx:
            return nil
        case .union:
            return nil
        case .balance:
            return nil
        default:
            return nil
        }
    }
}


//MARK:--- 公司的支付插件列表 和余额不在同一数组，需要进行整合 ----------
public struct M_PayType: CD_SwiftyJSONProtocol {
    public init(_ json: JSON, tag: CD_SwiftyJSONTagProtocol?) {
        list = json["datas"].arrayValue.compactMap{M_PayType.Model($0, tag: nil)}
        
        /*balance = json["balance"].stringValue
        let pp = M_PayType.Model()
        pp.type = .balance
        pp.title = "余额支付"
        pp.price = balance
        pp.select = false
        list.append(pp)
        
        User.shared.detail.balance = balance*/
    }
    
    public var balance:String = ""
    public var list:[Model] = []
    
    
    public class Model: CD_SwiftyJSONProtocol {
        public init() { }
        required public init(_ json: JSON, tag: CD_SwiftyJSONTagProtocol?) {
            plugin_id = json["plugin_id"].stringValue
            config_id = json["config_id"].stringValue
            icon = ""//json["logo"].stringValue
            switch plugin_id {
            case "enetePlugin":
                type = .union
            case "appAlipayDirectPlugin":
                type = .ali
            case "appWeixinPayPlugin":
                type = .wx
            default:
                type = .balance
            }
            title = json["name"].string ?? type.title
        }
        public var id:String = ""
        public var icon = ""
        public var image:UIImage? {
            get {
                return type.icon
            }
        }
        public var title = ""
        public var price = ""
        public var select:Bool = false
        public var type:PayType = .balance
        
        public var plugin_id = ""
        public var config_id = ""
    }

}

public struct M_PayInfo: CD_SwiftyJSONProtocol {
    public init(_ json: JSON, tag: CD_SwiftyJSONTagProtocol?) {
        self.json = json
        
        key = json["key"].stringValue
        partner = json["partner"].stringValue
        payment_sn = json["payment_sn"].stringValue
        amount = json["amount"].stringValue
        back_notify_url = json["back_notify_url"].stringValue
        
        
        
        orderString = json["orderString"].stringValue
        
        tn = json["tn"].stringValue
        
        prepay_id = json["prepay_id"].stringValue
        mch_id = json["mch_id"].stringValue
        nonce_str = json["nonce_str"].stringValue
        timestamp = json["timestamp"].stringValue
        sign = json["sign"].stringValue
        
        
        //aliOrder = PGPay.Ali.Signer.Order(json, tag: nil)
        //wxOrder = PGPay.WX.Order(json, tag: nil)
    }
    
    public var json:JSON
    
    // ------------ 阿里的签名参数 -----------
    public var key = ""
    public var partner = ""
    public var payment_sn = ""
    public var amount = ""
    public var back_notify_url = ""
    
    /// ------------ 阿里的签名 如果服务器已经签名 -----------
    public var orderString = ""
    
    
    // ------------ 银联的支付信息 -----------
    public var tn = ""
    // ------------ 微信的支付信息 -----------
    public var prepay_id = ""
    public var mch_id = ""
    public var nonce_str = ""
    public var timestamp = ""
    public var sign = ""
    
    //var aliOrder:PGPay.Ali.Signer.Order
    //var wxOrder:PGPay.WX.Order
}

/*
extension PGPay.Ali.Signer.Order: CD_SwiftyJSONProtocol {
    init(_ json: JSON, tag: CD_SwiftyJSONTagProtocol?) {
        self.init(partner: json["partner"].stringValue,
                  seller_id: json["partner"].stringValue,
                  out_trade_no: json["payment_sn"].stringValue,
                  total_fee: json["amount"].stringValue,
                  notify_url: json["back_notify_url"].stringValue,
                  body: json["payment_sn"].stringValue,
                  subject: json["payment_sn"].stringValue,
                  service:"mobile.securitypay.pay")
    }
}
extension PGPay.WX.Order: CD_SwiftyJSONProtocol {
    public init(_ json: JSON, tag: CD_SwiftyJSONTagProtocol?) {
        self.init(partnerId:json["mch_id"].stringValue,
                  prepayId:json["prepay_id"].stringValue,
                  nonceStr:json["nonce_str"].stringValue,
                  timeStamp:json["timestamp"].uInt32Value,
                  sign:json["sign"].stringValue)
    }
}
*/
