//Created  on 2019/7/10 by  LCD:https://github.com/liucaide .

/***** 模块文档 *****
 *
 */




import Foundation
import CaamDau
import SwiftyJSON
/*/MARK:--- 商品 ----------
struct M_Goods {
    var store:String = ""
    var storeId:String = ""
    
    var id:String = ""
    var code:String = ""
    var icon:String = ""
    var name:String = ""
    var fullname:String = ""
    var price1:String = "0.00"
    var price2:String = "0.00"
    var price3:String = "0.00"
    var item_model = ""
    /// 活动说明
    var explain:String = ""
    var active_type:ActiveType = .none
    /// 折扣
    var discount:String = ""
    /// 库存
    var inventory:Int = 10000
    /// 图片列表
    var images:[Images] = []
    /// 是否已收藏
    var isFavorite:Bool = false
    
    var iconheight:CGFloat = CD.screenW
    
    var _iconheight:CGFloat {
        guard let c = M_Goods.UserDefaults.imagesSize.value as? [String:String] else{
            return Config.fit.fit(132)
        }
        guard let cc = c[icon] else{
            return Config.fit.fit(132)
        }
        guard !cc.isEmpty else{
            return Config.fit.fit(132)
        }
        guard CGFloat(cc.floatValue) > 0 else{
            return Config.fit.fit(132)
        }
        let hh = (CD.screenW-Config.fit.fit(11))/CGFloat(cc.floatValue)
        return hh
    }
}
extension M_Goods {
    enum Tags:CD_SwiftyJSONTagProtocol {
        case list
        case discount
        case detail
        case searchStore
    }
    
    enum ActiveType:Int {
        case none = 0
        case t样机
        case t秒杀
        case t拼团
        case t折扣
    }
}
extension M_Goods.Tags {
    var keyPrice1:String {
        return "price"
    }
    var keyPrice2:String {
        return "active_price"
    }
    var keyPrice3:String {
        return "factory_price"
    }
    var keyStoreId:String {
        switch self {
        case .detail:
            return "companyinfoid"
        case .searchStore:
            return "company_id"
        default:
            return "companyinfoid"
        }
        
    }
    var keyStore:String {
        switch self {
        case .detail:
            return "company_name"
        case .searchStore:
            return "company_name"
        default:
            return "company_name"
        }
        
    }
}

extension M_Goods: CD_SwiftyJSONProtocol {
    init(_ json: JSON, tag: CD_SwiftyJSONTagProtocol?) {
        store = json["company_name"].stringValue
        storeId = json["companyinfoid"].stringValue
        
        id = json["productid"].stringValue
        code = json["vonder_code"].stringValue
        icon = json["image"].stringValue
        name = json["name"].stringValue
        fullname = json["fullname"].stringValue
        price1 = json["price"].stringValue
        price2 = json["active_price"].stringValue
        price3 = json["factory_price"].stringValue

        item_model = json["item_model"].stringValue
        
        /// 活动说明
        explain = json["explain"].stringValue
        /// 折扣
        discount = json["discount"].stringValue
        
        active_type = ActiveType(rawValue: json["active_type"].intValue) ?? .none
        // - 详情
        images = json["image_list"].arrayValue.compactMap{Images($0, tag: nil)}
        
        guard let tag = tag as? M_Goods.Tags else {
            return
        }
        store = json[tag.keyStore].stringValue
        storeId = json[tag.keyStoreId].stringValue
//        price1 = json[tag.keyPrice1].stringValue
//        price2 = json[tag.keyPrice2].stringValue
//        price3 = json[tag.keyPrice3].stringValue
        
    }
}



extension M_Goods {
    struct Images: CD_SwiftyJSONProtocol {
        init(_ json: JSON, tag: CD_SwiftyJSONTagProtocol?) {
            small = json["thumbnail"].stringValue
            order = json["order"].stringValue
            source = json["source"].stringValue
            big = json["large"].stringValue
            medium = json["medium"].stringValue
            image = json["image"].stringValue
        }
        var image = ""
        var small = ""
        var big = ""
        var medium = ""
        var order = ""
        var source = ""
        var height:CGFloat = CD.screenW
        
        var _height:CGFloat {
            guard let c = M_Goods.UserDefaults.imagesSize.value as? [String:String] else{
                return CD.screenW
            }
            guard let cc = c[image] else{
                return CD.screenW
            }
            guard !cc.isEmpty else{
                return CD.screenW
            }
            guard CGFloat(cc.floatValue) > 0 else{
                return CD.screenW
            }
            let hh = CD.screenW/CGFloat(cc.floatValue)
            return hh
        }
    }
    
}
*/








//MARK:--- 商铺 ----------
public struct M_Store {
    public var id = ""
    public var name = ""
    
    public var list:[M_Goods] = []
    
    public enum Tags: CD_SwiftyJSONTagProtocol {
        case search(_ tag:CD_SwiftyJSONTagProtocol)
        
        public var key: String {
            switch self {
            case .search:
                return "product_store"
            }
        }
    }
}

extension M_Store: CD_SwiftyJSONProtocol {
    public init(_ json: JSON, tag: CD_SwiftyJSONTagProtocol?) {
        name = json["company_name"].stringValue
        id = json["company_id"].stringValue
        list = json["product_store"].arrayValue.compactMap{M_Goods($0, tag: M_Goods.Tags.searchStore)}
        guard let tag = tag as? Tags else {
            return
        }
        switch tag {
        case .search(let t):
            list = json[tag.key].arrayValue
                .compactMap{M_Goods($0, tag: t)}
            
        }
    }
}
