//Created  on 2018/02/27  by LCD :https://github.com/liucaide .
/***** 模块文档 *****
 * 登录注册页面 响应模型
 */

import Foundation
import UIKit
import CaamDau

public class M_Sign {
    public enum Style {
        case loginPwd
        case loginCode
        case register
        case pwdChange
        case pwdForget
        
        /// 如果不区分验证码类型，则可设为同一值，或使用账号作为倒计时id
        public var timerId:String {
            switch self {
            case .loginCode:
                return "sign_code_login"
            case .pwdForget:
                return "sign_pwd_forget"
            case .pwdChange:
                return "sign_pwd_change"
            case .register:
                return "sign_LegalRegister"
            default:
                return "sign_code"
            }
        }
        
        public var title:String {
            switch self {
            case .loginCode, .loginPwd:
                return "登录"
            case .pwdForget:
                return "忘记密码"
            case .pwdChange:
                return "修改密码"
            case .register:
                return "注册"
            default:
                return ""
            }
        }
        
        public var submit:String {
            switch self {
            case .loginCode, .loginPwd:
                return "登录"
            case .pwdForget:
                return "提交"
            case .pwdChange:
                return "提交"
            case .register:
                return "注册"
            default:
                return "提交"
            }
        }
    }
    
    public var style:Style? {
        didSet{
            verification()
        }
    }
    
    public var account:String = "" {
        didSet{
            verification()
        }
    }
    public var accountMaxCount:Int = 11
    public var accountMixCount:Int = 1
    public var accountRegEx:String {
        get{
            switch style {
            case .loginCode?, .register?, .pwdChange?, .pwdForget?:
                return CD_RegEx.tMobile(nil).patternValue
            case .loginPwd?:
                return CD_RegEx.tMobile(nil).patternValue  //CD_RegEx.tUserName(CD_RegEx.Name.value0).patternValue
            default:
                return ""
            }
        }
    }
    
    public var password:String = "" {
        didSet{
            verification()
        }
    }
    public var passwordVerify:String = "" {
        didSet{
            verification()
        }
    }
    public var passwordMaxCount:Int = 20
    public var passwordMixCount:Int = 6
    public var passwordRegEx:String = CD_RegEx.tPassword(CD_RegEx.Password.value3("^.{6,20}$")).patternValue
    
    public var verifyCode:String = "" {
        didSet{
            verification()
        }
    }
    /// 是否同意用户协议
    public var isAgreement:Bool = true {
        didSet{
            verification()
        }
    }
    
    
    public var verifyCodeMaxCount:Int = 6
    public var verifyCodeMixCount:Int = 4
    public var blockCodeEnabled:((Bool) -> (Void))?
    public var isCodeEnabled:Bool = false {
        didSet{
            guard isCodeEnabled != oldValue else {
                return
            }
            blockCodeEnabled?(isCodeEnabled)
        }
    }
    
    
    public var blockSubmitEnabled:((Bool) -> (Void))?
    public var isSubmitEnabled:Bool = false {
        didSet{
            guard isSubmitEnabled != oldValue else {
                return
            }
            blockSubmitEnabled?(isSubmitEnabled)
        }
    }
    
    
    func verification() {
        switch style {
        case .loginPwd?:
            isSubmitEnabled =
                //CD_RegEx.match(account, pattern: accountRegEx)
                account.count >= accountMixCount
                && account.count <= accountMaxCount
                && CD_RegEx.match(password, pattern: passwordRegEx)
                && password.count >= passwordMixCount
                && password.count <= passwordMaxCount
                && isAgreement
            
        case .loginCode?:
            isCodeEnabled =
                CD_RegEx.match(account, pattern: accountRegEx)
                && account.count >= accountMixCount
                && account.count <= accountMaxCount
            
            isSubmitEnabled =
                isCodeEnabled
                && verifyCode.count >= verifyCodeMixCount
                && verifyCode.count <= verifyCodeMaxCount
                && isAgreement
        case .register?:
            isCodeEnabled =
                CD_RegEx.match(account, pattern: accountRegEx)
                && account.count >= accountMixCount
                && account.count <= accountMaxCount
            
            isSubmitEnabled =
                isCodeEnabled
                && CD_RegEx.match(password, pattern: passwordRegEx)
                && password.count >= passwordMixCount
                && password.count <= passwordMaxCount
                && verifyCode.count >= verifyCodeMixCount
                && verifyCode.count <= verifyCodeMaxCount
                && isAgreement
        case .pwdChange?, .pwdForget?:
            isCodeEnabled =
                CD_RegEx.match(account, pattern: accountRegEx)
                && account.count >= accountMixCount
                && account.count <= accountMaxCount
            
            isSubmitEnabled =
                CD_RegEx.match(account, pattern: accountRegEx)
                && account.count >= accountMixCount
                && account.count <= accountMaxCount
                && CD_RegEx.match(password, pattern: passwordRegEx)
                && password.count >= passwordMixCount
                && password.count <= passwordMaxCount
                && passwordVerify == password
            //&& passwordVerify.count >= passwordMixCount
            //&& passwordVerify.count <= passwordMaxCount
        //&& isAgreement
        case .none:
            break
        }
    }
    private init(){}
    public init(_ style:M_Sign.Style) {
        self.style = style
    }
}
