//Created  on 2018/02/27  by LCD :https://github.com/liucaide .

/***** 模块文档 *****
 * 用户管理模块
 */


import Foundation
import UIKit
import CaamDau
import SwiftyJSON

public extension User {
    public struct InfoModel: Codable {
        public var success:String = ""
        public var error:String = ""
        public var sto_id:String = ""
        public var userid:String = ""
        public var username:String = ""
        public var birth:String = ""
        public var gender:String = ""
        public var imagename:String = ""
        public var nickname:String = ""
        public var memo:String = ""
        public var name:String = ""
        public var mobile:String = ""
        public var member_type:String = ""
        public var company_name:String = ""
        public var company_info_id:String = ""
        public var company_code:String = ""
        public var app_file_upload_url:String = ""
        public var server_id:String = ""
        public var openfire_url:String = ""
        public var address_flag:String = ""
        public var sid = ""
        public var is_change:Int = 1
        public init() {}
    }
}

extension User.InfoModel:CD_SwiftyJSONProtocol {
    public init(_ json: JSON, tag: CD_SwiftyJSONTagProtocol?) {
        sto_id = json["sto_id"].stringValue
        userid = json["userid"].stringValue
        username = json["username"].stringValue
        birth = json["birth"].stringValue
        gender = json["gender"].stringValue
        imagename = json["imagename"].stringValue
        nickname = json["nickname"].stringValue
        memo = json["memo"].stringValue
        name = json["name"].stringValue
        mobile = json["mobile"].stringValue
        member_type = json["member_type"].stringValue
        company_info_id = json["company_info_id"].stringValue
        company_code = json["company_code"].stringValue
        app_file_upload_url = json["app_file_upload_url"].stringValue
        server_id = json["server_id"].stringValue
        openfire_url = json["openfire_url"].stringValue
        address_flag = json["address_flag"].stringValue
        sid = json["sid"].stringValue
        is_change = json["is_change"].int ?? 1
        User.shared.token = sid
    }
}


/*
{
    "success": "2",
    "sto_id": 12,
    "userid": "B1AEC2C2",
    "username": "张三",
    "birth": "",
    "gender": "male",
    "imagename": "http://mk.5mall.com/upload/image/twkj/2019/06/15/6ffe5032-75b1-4c33-a645-3b856a95bb21-source.jpg",
    "nickname": "张三",
    "name": "张三",
    "mobile": "13907611201",
    "member_type": 1,
    "company_info_id": 9,
    "company_code": "twkj",
    "app_file_upload_url": "http://mk.5mall.com/m/file/upload.jhtml?companyCode=twkj",
    "server_id": 0,
    "openfire_url": "im.5mall.com",
    "address_flag": "2"
}
*/


//MARK:--- 用户详细信息 ----------
public extension User {
    public struct Detail: Codable {
        public var success = ""
        public var waitingPaymentOrderCount:Int = 0
        public var waitingShippingOrderCount:Int = 0
        public var waitingGetOrderCount:Int = 0
        public var reviewCount:Int = 0
        public var imagename:String = ""
        public var username:String = ""
        public var mobile:String = ""
        public var name:String = ""
        public var recharge:String = "0.00"
        public var balance:String = "0.00"
        public var line_of_credit:String = "0.00"
        public var rebate:String = "0.00"
        public var carNum:Int = 0
        public var feedback_hotline:String = ""
        public init(){}
    }
}
extension User.Detail:CD_SwiftyJSONProtocol {
    public init(_ json: JSON, tag: CD_SwiftyJSONTagProtocol?) {
        success = json["success"].stringValue
        waitingPaymentOrderCount = json["waitingPaymentOrderCount"].intValue
        waitingShippingOrderCount = json["waitingShippingOrderCount"].intValue
        waitingGetOrderCount = json["waitingGetOrderCount"].intValue
        reviewCount = json["reviewCount"].intValue
        imagename = json["imagename"].stringValue
        username = json["username"].stringValue
        mobile = json["mobile"].stringValue
        name = json["name"].stringValue
        recharge = json["recharge"].string ?? "0.00"
        balance = json["balance"].string ?? "0.00"
        line_of_credit = json["line_of_credit"].string ?? "0.00"
        rebate = json["rebate"].string ?? "0.00"
        feedback_hotline = json["feedback_hotline"].stringValue
    }
}

/*
{
    "success": "2",
    "waitingPaymentOrderCount": 8,
    "waitingShippingOrderCount": 10,
    "waitingGetOrderCount": 0,
    "reviewCount": 0,
    "imagename": "http://mk.5mall.com/upload/image/twkj/2019/06/15/6ffe5032-75b1-4c33-a645-3b856a95bb21-source.jpg",
    "username": "张三",
    "mobile": "13907611201",
    "name": "张三",
    "recharge": "5000.02",
    "balance": "-1489.98",
    "line_of_credit": "0.00",
    "rebate": "0.00"
}
*/
