//Created  on 2019/7/21 by  LCD:https://github.com/liucaide .

/***** 模块文档 *****
 *
 */




import UIKit
import CaamDau

public class Cell_CountDown: UITableViewCell {
    @IBOutlet weak var img_icon: UIImageView!
    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var lab_day: UILabel!
    @IBOutlet weak var lab_hour: UILabel!
    @IBOutlet weak var lab_minute: UILabel!
    @IBOutlet weak var lab_second: UILabel!
    
    var ob: NSObjectProtocol?
    override public func awakeFromNib() {
        super.awakeFromNib()
        
        self.contentView.cd.background(UIColor.cd_hex("505f7f"))
        
        
    }
    var timeId:String = "" {
        didSet{
            guard timeId != oldValue else {
                return
            }
            CD_Timer.remove("Cell_CountDown_"+oldValue)
            ob = CD.notice.addObserver(forName: Notification.Name("Cell_CountDown_"+timeId), object: nil, queue: OperationQueue.main) { [weak self](n) in
                guard let self = self else{ return }
                guard let m = n.userInfo?["Cell_CountDown_"+self.timeId] as? CD_Timer.Model else {
                    return
                }
                self.makeTime(m)
            }
        }
    }
    func makeTime(_ model: CD_Timer.Model) {
        var day = model.day.stringValue + "天"
        day = model.day > 0 ? day : ""
        self.lab_day.cd
            .text(day)
        
        var hour = model.hour.stringValue
        hour = model.hour > 9 ? hour : "0" + hour
        self.lab_hour.cd.text(hour)
        
        var minute = model.minute.stringValue
        minute = model.minute > 9 ? minute : "0" + minute
        self.lab_minute.cd.text(minute)
        
        var second = model.second.stringValue
        second = model.second > 9 ? second : "0" + second
        self.lab_second.cd.text(second)
    }
    
    deinit {
        CD_Timer.remove("Cell_CountDown_"+timeId)
    }
}


extension Cell_CountDown: CD_RowCellUpdateProtocol {
    public typealias ConfigModel = Any
    
    public typealias DataSource = (String, String, TimeInterval)
    
    public func row_update(dataSource data: (String, String, TimeInterval)) {
        lab_title.cd.text(data.0)
        timeId = data.1
        CD_Timer.make(.notification("Cell_CountDown_"+timeId, data.2, 1))
    }
}
