//Created  on 2019/7/21 by  LCD:https://github.com/liucaide .

/***** 模块文档 *****
 *
 */




import UIKit
import CaamDau

public class Cell_Image: UITableViewCell {
    public static let bundle:String = "UtilityViews"
    @IBOutlet weak var img_icon: UIImageView!
    @IBOutlet weak var img_iconT: NSLayoutConstraint!
    @IBOutlet weak var img_iconL: NSLayoutConstraint!
    
    override public func awakeFromNib() {
        super.awakeFromNib()
        
    }
}

extension Cell_Image {
    public struct Model {
        public var top:CGFloat = 0
        public var left:CGFloat = 0
        public var style:UIView.ContentMode = .scaleAspectFit
        public init(top:CGFloat = 0, left:CGFloat = 0, style:UIView.ContentMode = .scaleAspectFit) {
            self.top = top
            self.left = left
            self.style = style
        }
    }
}

extension Cell_Image: CD_RowCellUpdateProtocol {
    public typealias ConfigModel = Cell_Image.Model?
    
    public typealias DataSource = String
    
    public func row_update(config data: Cell_Image.Model?) {
        let mo = data ?? Cell_Image.Model()
        img_icon.cd.content(mo.style)
        img_iconL.constant = mo.left
        img_iconT.constant = mo.top
    }
    public func row_update(dataSource data: String) {
        img_icon.cd.setImage(data)
    }
}

extension Cell_Image: CD_RowUpdateProtocol {
    public func row_update(_ data: String, id: String, tag: Int, frame: CGRect, callBack: CD_RowCallBack?) {
        img_icon.cd.setImage(data)
    }
}
