//Created  on 2019/8/9 by  LCD:https://github.com/liucaide .

/***** 模块文档 *****
 *
 */




import UIKit
import CaamDau
import CaamDau
extension Cell_Images {
    static func makeCell(_ images:[String], h:CGFloat = 80, left:CGFloat = 15) -> CD_CellProtocol {
        return CD_RowCell<Cell_Images>.init(data: images, config: left, frame: CGRect(h:h), bundleFrom: Cell_Images.bundle, callBack: { (a) in
            guard let idx = a as? Int else{return}
            TWPhotoBrowser.show(images, index: UInt(idx))
        })
    }
}

public class Cell_Images: UITableViewCell {
    public static let bundle:String = "UtilityViews"
    @IBOutlet weak var stack_0: UIStackView!
    @IBOutlet weak var stack_1: UIStackView!
    @IBOutlet weak var stack_2: UIStackView!
    @IBOutlet weak var stack_L: NSLayoutConstraint!
    var callBack: CD_RowCallBack?
    override public func awakeFromNib() {
        super.awakeFromNib()
    }
    
    @IBAction func buttonClick(_ sender: UIButton) {
        callBack?(sender.tag)
    }
}

extension Cell_Images: CD_RowCellUpdateProtocol {
    public typealias ConfigModel = CGFloat
    
    public typealias DataSource = [String]
    public func row_update(config data: CGFloat) {
        stack_L.constant = data
    }
    public func row_update(dataSource data: [String]) {
        [stack_0, stack_1, stack_2].forEach{
            $0?.cd.isHidden(true)
            $0?.arrangedSubviews.forEach {
                ($0 as! UIButton).cd
                    .background(nil)
                    .image(nil)
                    .isUser(false)
                    .imageViewContent(.scaleAspectFill)
            }
        }
        switch data.count {
        case 1,2,3:
            stack_0.cd.isHidden(false)
            for (i, item) in data.enumerated() {
                let btn = stack_0.arrangedSubviews[i] as! UIButton
                btn.cd.tag(i).setImage(item).isUser(true)
            }
            
        case 5,6:
            stack_0.cd.isHidden(false)
            stack_1.cd.isHidden(false)
            for (i, item) in data.enumerated() {
                if i < 3 {
                    let btn = stack_0.arrangedSubviews[i] as! UIButton
                    btn.cd.tag(i).setImage(item).isUser(true)
                }else{
                    let btn = stack_1.arrangedSubviews[i-3] as! UIButton
                    btn.cd.tag(i).setImage(item).isUser(true)
                }
            }
            
        case 7,8,9:
            stack_0.cd.isHidden(false)
            stack_1.cd.isHidden(false)
            stack_2.cd.isHidden(false)
            for (i, item) in data.enumerated() {
                if i < 3 {
                    let btn = stack_0.arrangedSubviews[i] as! UIButton
                    btn.cd.tag(i).setImage(item).isUser(true)
                }
                else if i < 6{
                    let btn = stack_1.arrangedSubviews[i-3] as! UIButton
                    btn.cd.tag(i).setImage(item).isUser(true)
                }
                else{
                    let btn = stack_2.arrangedSubviews[i-6] as! UIButton
                    btn.cd.tag(i).setImage(item).isUser(true)
                }
            }
            
        case 4:
            stack_0.cd.isHidden(false)
            stack_1.cd.isHidden(false)
            do{
                let btn = stack_0.arrangedSubviews[0] as! UIButton
                btn.cd.tag(0).setImage(data[0]).isUser(true)
            }
            do{
                let btn = stack_0.arrangedSubviews[1] as! UIButton
                btn.cd.tag(1).setImage(data[1]).isUser(true)
            }
            do{
                let btn = stack_1.arrangedSubviews[0] as! UIButton
                btn.cd.tag(2).setImage(data[2]).isUser(true)
            }
            do{
                let btn = stack_1.arrangedSubviews[1] as! UIButton
                btn.cd.tag(3).setImage(data[3]).isUser(true)
            }
        default:
            break
        }
    }
    
    public func row_update(callBack block: CD_RowCallBack?) {
        callBack = block
    }
}

