//Created  on 2019/11/25 by  LCD:https://github.com/liucaide .

/***** 模块文档 *****
 *
 */




import UIKit
import CaamDau
extension Cell_ImagesFour {
    public static func makeCell(_ images:[String], h:CGFloat = 60, left:CGFloat = 15) -> CD_CellProtocol {
        return CD_RowCell<Cell_ImagesFour>.init(data: images, config: left, frame: CGRect(h:h), bundleFrom: Cell_ImagesFour.bundle, callBack: { (a) in
            guard let idx = a as? Int else{return}
            TWPhotoBrowser.show(images, index: UInt(idx))
        })
    }
}

public class Cell_ImagesFour: UITableViewCell {
    public static let bundle:String = "UtilityViews"
    @IBOutlet weak var stack_0: UIStackView!
    @IBOutlet weak var stack_L: NSLayoutConstraint!
    var callBack: CD_RowCallBack?
    override public func awakeFromNib() {
        super.awakeFromNib()
        
        
    }
    
    override public func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
        
        
    }
    @IBAction func buttonClick(_ sender: UIButton) {
        callBack?(sender.tag)
    }
    
}


extension Cell_ImagesFour: CD_RowCellUpdateProtocol {
    public typealias ConfigModel = CGFloat
    
    public typealias DataSource = [String]
    public func row_update(config data: CGFloat) {
        stack_L.constant = data
    }
    public func row_update(dataSource data: [String]) {
        
        stack_0.arrangedSubviews.forEach {
            ($0 as! UIButton).cd
            .background(nil)
            .image(nil)
            .isUser(false)
            .imageViewContent(.scaleAspectFill)
        }
        for (i, item) in data.enumerated() {
            let btn = stack_0.arrangedSubviews[i] as! UIButton
            btn.cd.tag(i).setImage(item).isUser(true)
        }
    }
    
    public func row_update(callBack block: CD_RowCallBack?) {
        callBack = block
    }
}

