//Created  on 2019/7/10 by  LCD:https://github.com/liucaide .

/***** 模块文档 *****
 *
 */




import UIKit
import CaamDau



public extension Cell_Line {
    public static func makeLineMin(left:CGFloat = 0, color:UIColor = Config.color.line_1) -> CD_CellProtocol {
        return CD_RowCell<Cell_Line>.init( config: Cell_Line.Model(left:left, color:color), frame: CGRect(h:0.5), bundleFrom: Cell_Line.bundle)
    }
    public static func makeLineMiddle(h:CGFloat = 10 ,color:UIColor = Config.color.bg, didSelect:CD_RowDidSelectBlock? = nil) -> CD_CellProtocol {
        return CD_RowCell<Cell_Line>.init( config: Cell_Line.Model(color:color), frame: CGRect(h:h), bundleFrom: Cell_Line.bundle, didSelect:didSelect)
    }
}





public class Cell_Line: UITableViewCell {
    public static let bundle:String = "UtilityViews"
    public struct Model {
        let left:CGFloat
        let right:CGFloat
        let top:CGFloat
        let bottom:CGFloat
        let color:UIColor
        let colorbg:UIColor
        let corners:(UIRectCorner, CGSize)
        
        let style:UITableViewCell.SelectionStyle
        public init(top:CGFloat = 0, left:CGFloat = 0, bottom:CGFloat = 0, right:CGFloat = 0, color:UIColor = .white, colorbg:UIColor = .white, style:UITableViewCell.SelectionStyle = .none, corners:(UIRectCorner, CGSize) = ([],.zero)) {
            self.top = top
            self.bottom = bottom
            self.left = left
            self.right = right
            self.color = color
            self.style = style
            self.colorbg = colorbg
            self.corners = corners
        }
    }
    
    @IBOutlet weak var view_line: UIView!
    @IBOutlet weak var view_line_L: NSLayoutConstraint!
    @IBOutlet weak var view_line_R: NSLayoutConstraint!
    @IBOutlet weak var view_line_T: NSLayoutConstraint!
    @IBOutlet weak var view_line_B: NSLayoutConstraint!
    var model:Model = Model()
    override public func awakeFromNib() {
        super.awakeFromNib()
        self.selectionStyle = .none
        self.contentView.cd.background(UIColor.white)
    }

    override public func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
    }
    
    override public func draw(_ rect: CGRect) {
        super.draw(rect)
        view_line.cd.rounded(model.corners.0, model.corners.1)
    }
    
}

extension Cell_Line: CD_RowCellUpdateProtocol {
    public typealias DataSource = Cell_Line.Model
    
    public typealias ConfigModel = Cell_Line.Model
    public func row_update(config data: Cell_Line.Model) {
        model = data
        self.view_line.cd.background(data.color)
        self.contentView.cd.background(data.colorbg)
        self.cd.background(data.colorbg)
        self.view_line_T.constant = data.top
        self.view_line_L.constant = data.left
        self.view_line_B.constant = data.bottom
        self.view_line_R.constant = data.right
        self.selectionStyle = data.style
    }
}


extension Cell_Line: CD_RowUpdateProtocol {
    public func row_update(_ data: Cell_Line.Model, id: String, tag: Int, frame: CGRect, callBack: CD_RowCallBack?) {
        model = data
        self.view_line.cd.background(data.color)
        self.contentView.cd.background(data.colorbg)
        self.cd.background(data.colorbg)
        self.view_line_T.constant = data.top
        self.view_line_L.constant = data.left
        self.view_line_B.constant = data.bottom
        self.view_line_R.constant = data.right
        self.selectionStyle = data.style
    }
}
