//Created  on 2019/7/10 by  LCD:https://github.com/liucaide .

/***** 模块文档 *****
 *
 */




import UIKit
import CaamDau

public extension Cell_OrderAddress {
    public static func make(data:Cell_OrderAddress.DataSource, h:CGFloat = 80, didSelect:CD_RowDidSelectBlock? = nil) -> CD_CellProtocol {
        return CD_RowCell<Cell_OrderAddress>.init(data:data, frame: CGRect(h:h), bundleFrom: Cell_Line.bundle, didSelect:didSelect)
    }
}



public class Cell_OrderAddress: UITableViewCell {
    public static let bundle:String = "UtilityViews"
    @IBOutlet weak var lab_name: UILabel!
    @IBOutlet weak var lab_address: UILabel!
    @IBOutlet weak var lab_to: UILabel!
    @IBOutlet weak var img_line: UIImageView!
    
    override public func awakeFromNib() {
        super.awakeFromNib()
        
        lab_name.cd
            .text(Config.color.txt_1)
            .text(Config.font.fontMedium(18, fit: true))
            .text("")
        
        lab_address.cd
            .text(Config.color.txt_1)
            .text(Config.font.font(12, fit: true))
            .text("")
        
        lab_to.cd
            .text(Config.color.txt_1)
            .text(CD_IconFont.tright(20).font)
            .text(CD_IconFont.tright(20).text)
        
        img_line.cd.image(Assets().com_adressLine)
    }

    override public func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

    }

}

extension Cell_OrderAddress: CD_RowCellUpdateProtocol {
    public typealias ConfigModel = Any
    
    public typealias DataSource = (String, String, Bool)
    
    public func row_update(dataSource data: (String, String, Bool)) {
        lab_name.cd.text(data.0)
        lab_address.cd
            .isHidden(data.1.isEmpty)
            .text(data.1)
        lab_to.cd.isHidden(data.2)
    }
    
}
