//Created  on 2019/11/25 by  LCD:https://github.com/liucaide .

/***** 模块文档 *****
 *
 */




import UIKit
import CaamDau
public class M_SelectImages  {
    public lazy var picker:TWImagePicker = {
        let pp = TWImagePicker()
        pp.maxPhotoCount = 9
        return pp
    }()
    public var height:CGFloat = 80
    
    public init(_ max:Int = 9, height:CGFloat = 80) {
        picker.maxPhotoCount = max
        self.height = height
    }
}

extension Cell_SelectImages {
    /// left 、height 参数应该遵守计算后布局不超出容器范围
    public static func makeCell(_ model:M_SelectImages, left:CGFloat = 15, height:CGFloat = 80, completion:(()->Void)?) -> CD_CellProtocol {
        return CD_RowCell<Cell_SelectImages>.init(data: model.picker.images, config: (left, height), frame: CGRect(h:model.height), bundleFrom: Cell_SelectImages.bundle, callBack: { [weak model](a) in
            guard let model = model else{ return }
            guard let idx = a as? Int else{ return }
            guard idx < 100 else {
                model.picker.remove(idx-100)
                let count = model.picker.images.count - 1
                model.height = CGFloat((count/3 + 1))*height + CGFloat(count/3 * 10)
                completion?()
                return
            }
            model.picker.showPhoto(idx, completion: { [weak model] in
                let count = model!.picker.images.count - 1
                model?.height = CGFloat((count/3 + 1))*height + CGFloat(count/3 * 10)
                completion?()
            })
        })
    }
}


public class Cell_SelectImages: UITableViewCell {
    public static let bundle:String = "UtilityViews"
    @IBOutlet weak var btn_0: UIButton!
    @IBOutlet weak var btn_1: UIButton!
    @IBOutlet weak var btn_2: UIButton!
    @IBOutlet weak var btn_3: UIButton!
    @IBOutlet weak var btn_4: UIButton!
    @IBOutlet weak var btn_5: UIButton!
    @IBOutlet weak var btn_6: UIButton!
    @IBOutlet weak var btn_7: UIButton!
    @IBOutlet weak var btn_8: UIButton!
    @IBOutlet weak var view_del0: UIView!
    @IBOutlet weak var view_del1: UIView!
    @IBOutlet weak var view_del2: UIView!
    @IBOutlet weak var view_del3: UIView!
    @IBOutlet weak var view_del4: UIView!
    @IBOutlet weak var view_del5: UIView!
    @IBOutlet weak var view_del6: UIView!
    @IBOutlet weak var view_del7: UIView!
    @IBOutlet weak var view_del8: UIView!
    @IBOutlet weak var btn_del0: UIButton!
    @IBOutlet weak var btn_del1: UIButton!
    @IBOutlet weak var btn_del2: UIButton!
    @IBOutlet weak var btn_del3: UIButton!
    @IBOutlet weak var btn_del4: UIButton!
    @IBOutlet weak var btn_del5: UIButton!
    @IBOutlet weak var btn_del6: UIButton!
    @IBOutlet weak var btn_del7: UIButton!
    @IBOutlet weak var btn_del8: UIButton!
    
    @IBOutlet weak var stack_0: UIStackView!
    @IBOutlet weak var stack_1: UIStackView!
    @IBOutlet weak var stack_2: UIStackView!
    @IBOutlet weak var stack_0_H: NSLayoutConstraint!
    @IBOutlet weak var stack_L: NSLayoutConstraint!
    
    override public func awakeFromNib() {
        super.awakeFromNib()
        
        let icon = CD_IconFont.tclose(15)
        let btns = [btn_0, btn_1, btn_2,
                    btn_3, btn_4, btn_5,
                    btn_6, btn_7, btn_8]
        let dels = [btn_del0, btn_del1, btn_del2,
                    btn_del3, btn_del4, btn_del5,
                    btn_del6, btn_del7, btn_del8]
        
        for (i, item) in btns.enumerated() {
            item?.cd.tag(i)
            item?.imageView?.cd.content(.scaleAspectFill)
        }
        
        
        for (i, item) in dels.enumerated() {
            item?.cd.tag(100+i)
                .text(Config.color.hex("f"))
                .text(icon.font)
                .text(icon.text)
        }
    }
    
    var callBack: CD_RowCallBack?
    @IBAction func buttonClick(_ sender: UIButton) {
        callBack?(sender.tag)
    }
    
}


extension Cell_SelectImages: CD_RowCellUpdateProtocol {
    public typealias ConfigModel = (CGFloat, CGFloat)
    
    public typealias DataSource = [UIImage]
    
    public func row_update(config data: (CGFloat, CGFloat)) {
        stack_L.constant = data.0
        stack_0_H.constant = data.1
    }
    
    public func row_update(callBack block: CD_RowCallBack?) {
        callBack = block
    }
    public func row_update(dataSource data: [UIImage]) {
        let count = data.count
        stack_1.cd.isHidden(count<=3)
        stack_2.cd.isHidden(count<=6)
        
        let btns = [btn_0, btn_1, btn_2,
                    btn_3, btn_4, btn_5,
                    btn_6, btn_7, btn_8]
        let dels = [view_del0, view_del1, view_del2,
                    view_del3, view_del4, view_del5,
                    view_del6, view_del7, view_del8]
        btns.forEach { $0?.cd.isHidden(true) }
        dels.forEach { $0?.cd.isHidden(true) }
        
        for (i, item) in btns.enumerated() where i < count {
            item?.cd.isHidden(false).image(data[i])
        }
        
        for (i, item) in dels.enumerated() where i < count {
            item?.cd.isHidden(data[i] == TWImagePicker.addImage)
        }
    }
}

