//Created  on 2019/11/25 by  LCD:https://github.com/liucaide .

/***** 模块文档 *****
 *
 */




import UIKit
import CaamDau

extension Cell_SelectImagesFour {
    /// left 、height 参数应该遵守计算后布局不超出容器范围
    public static func makeCell(_ model:M_SelectImages, left:CGFloat = 15, height:CGFloat = 60, completion:(()->Void)?) -> CD_CellProtocol {
        return CD_RowCell<Cell_SelectImagesFour>.init(data: model.picker.images, config: left, frame: CGRect(h:height), bundleFrom: Cell_SelectImagesFour.bundle, callBack: { [weak model](a) in
            guard let model = model else{ return }
            guard let idx = a as? Int else{ return }
            guard idx < 100 else {
                model.picker.remove(idx-100)
                completion?()
                return
            }
            model.picker.showPhoto(idx, completion: {
                completion?()
            })
        })
    }
}


public class Cell_SelectImagesFour: UITableViewCell {
    public static let bundle:String = "UtilityViews"
    @IBOutlet weak var btn_0: UIButton!
    @IBOutlet weak var btn_1: UIButton!
    @IBOutlet weak var btn_2: UIButton!
    @IBOutlet weak var btn_3: UIButton!
    @IBOutlet weak var view_del0: UIView!
    @IBOutlet weak var view_del1: UIView!
    @IBOutlet weak var view_del2: UIView!
    @IBOutlet weak var view_del3: UIView!
    @IBOutlet weak var btn_del0: UIButton!
    @IBOutlet weak var btn_del1: UIButton!
    @IBOutlet weak var btn_del2: UIButton!
    @IBOutlet weak var btn_del3: UIButton!
    @IBOutlet weak var stack_0: UIStackView!
    @IBOutlet weak var stack_L: NSLayoutConstraint!
    override public func awakeFromNib() {
        super.awakeFromNib()
        
        let icon = CD_IconFont.tclose(15)
        let btns = [btn_0, btn_1, btn_2,btn_3]
        let dels = [btn_del0, btn_del1, btn_del2,btn_del3]
        
        for (i, item) in btns.enumerated() {
            item?.cd.tag(i)
            item?.imageView?.cd.content(.scaleAspectFill)
        }
        
        
        for (i, item) in dels.enumerated() {
            item?.cd.tag(100+i)
                .text(Config.color.hex("f"))
                .text(icon.font)
                .text(icon.text)
        }
    }
    
    var callBack: CD_RowCallBack?
    @IBAction func buttonClick(_ sender: UIButton) {
        callBack?(sender.tag)
    }
    
}


extension Cell_SelectImagesFour: CD_RowCellUpdateProtocol {
    public typealias ConfigModel = CGFloat
    
    public typealias DataSource = [UIImage]
    
    public func row_update(config data: CGFloat) {
        stack_L.constant = data
    }
    
    public func row_update(callBack block: CD_RowCallBack?) {
        callBack = block
    }
    public func row_update(dataSource data: [UIImage]) {
        let count = data.count
        
        let btns = [btn_0, btn_1, btn_2, btn_3]
        let dels = [view_del0, view_del1, view_del2, view_del3]
        btns.forEach { $0?.cd.isHidden(true) }
        dels.forEach { $0?.cd.isHidden(true) }
        
        for (i, item) in btns.enumerated() where i < count {
            item?.cd.isHidden(false).image(data[i])
        }
        
        for (i, item) in dels.enumerated() where i < count {
            item?.cd.isHidden(data[i] == TWImagePicker.addImage)
        }
    }
}

