//Created  on 2019/7/10 by  LCD:https://github.com/liucaide .

/***** 模块文档 *****
 *
 */




import UIKit
import CaamDau

extension Cell_Store {
    public static func make(data:(UIImage, String), config:Model = Model(), h:CGFloat = 40, didSelect:CD_RowDidSelectBlock? = nil) -> CD_CellProtocol {
        return CD_RowCell<Cell_Store>.init(data:data, config: config, frame: CGRect(h:h), bundleFrom: Cell_Store.bundle, didSelect:didSelect)
    }
}

public class Cell_Store: UITableViewCell {
    public static let bundle:String = "UtilityViews"
    @IBOutlet weak var view_bg: UIView!
    @IBOutlet weak var view_bgL: NSLayoutConstraint!
    @IBOutlet weak var stack: UIStackView!
    @IBOutlet weak var stack_L: NSLayoutConstraint!
    @IBOutlet weak var icon: UIImageView!
    @IBOutlet weak var lab_title: UILabel!
    @IBOutlet weak var lab_to: UILabel!
    
    public struct Model {
        let left:CGFloat
        let leftStack:CGFloat
        let topStack:CGFloat
        let colorbg:UIColor
        let corners:(UIRectCorner, CGSize)
        
        let color:UIColor
        let font:UIFont
        let isTo:Bool
        
        public init(left:CGFloat = 0, leftStack:CGFloat = 0, topStack:CGFloat = 0, colorbg:UIColor = Config.color.bg, corners:(UIRectCorner, CGSize) = ([],.zero), color:UIColor = Config.color.txt_1, font:UIFont = Config.font.font(12), isTo:Bool = false) {
            self.left = left
            self.leftStack = left
            self.topStack = topStack
            self.colorbg = colorbg
            self.corners = corners
            
            self.color = color
            self.font = font
            self.isTo = isTo
        }
        
    }
    
    override public func awakeFromNib() {
        super.awakeFromNib()
        self.contentView.backgroundColor = Config.color.bg
        
        lab_title.cd
            .text("")
            .text(Config.color.txt_2)
            .text(Config.font.font(12, fit: true))
        
        lab_to.cd
            .isHidden(true)
            .text(Config.color.txt_3)
            .text(CD_IconFont.tright(15).text)
            .text(CD_IconFont.tright(15).font)
    }
}

extension Cell_Store: CD_RowCellUpdateProtocol {
    public typealias ConfigModel = Model
    public typealias DataSource = (UIImage, String)
    public func row_update(config data: Model) {
        lab_title.cd
            .text(data.color)
            .text(data.font)
        lab_to.cd.isHidden(!data.isTo)
    }
    
    public func row_update(dataSource data: (UIImage, String)) {
        icon.cd.image(data.0)
        lab_title.cd.text(data.1)
    }
}
