//Created  on 2019/7/10 by  LCD:https://github.com/liucaide .

/***** 模块文档 *****
 *
 */




import UIKit
import CaamDau



public extension Cell_Submit {
    public static func make5040(title:String) -> CD_CellProtocol {
        return CD_RowCell<Cell_Submit>.init( config: Cell_Submit.Model(title: title), frame: CGRect(h:50), bundleFrom: Cell_Submit.bundle)
    }
}



public class Cell_Submit: UITableViewCell {
    public static let bundle:String = "UtilityViews"
    @IBOutlet weak var btn_submit: UIButton!
    @IBOutlet weak var btn_submitL: NSLayoutConstraint!
    @IBOutlet weak var btn_submitH: NSLayoutConstraint!
    
    override public func awakeFromNib() {
        super.awakeFromNib()
        self.selectionStyle = .none
        self.contentView.cd.background(UIColor.white)
    }

    var callBack: CD_RowCallBack?
    @IBAction func buttonClick(_ sender: UIButton) {
        callBack?("")
    }
    
    
    public struct Model {
        var title:String
        var left:CGFloat
        var height:CGFloat
        var colorCell:UIColor
        var color:UIColor
        var colorTitle:UIColor
        var font:UIFont
        var gradient:[(UIColor, Float)]
        var corner:CGFloat
        public init(title:String, left:CGFloat = 15, height:CGFloat = 40, font:UIFont = Config.font.fontMedium(16), corner:CGFloat = 4, color:UIColor = Config.color.enabledTrue, colorTitle:UIColor = .white, colorCell:UIColor = .white, gradient:[(UIColor, Float)] = []) {
            self.title = title
            self.left = left
            self.height = height
            self.color = color
            self.colorTitle = colorTitle
            self.gradient = gradient
            self.font = font
            self.corner = corner
            self.colorCell = colorCell
        }
    }
}

extension Cell_Submit: CD_RowCellUpdateProtocol {
    public typealias DataSource = Any
    public typealias ConfigModel = Model
    
    public func row_update(callBack block: CD_RowCallBack?) {
        callBack = block
    }
    
    public func row_update(config data: Model) {
        self.contentView.cd.background(data.colorCell)
        btn_submit.cd
            .background(data.color)
            .corner(data.corner, clips: true)
            .text(data.colorTitle)
            .text(data.font)
            .text(data.title)
        
        btn_submitL.constant = data.left
        btn_submitH.constant = data.height
        
        guard !data.gradient.isEmpty else {
            return
        }
        btn_submit.cd
            .background(UIColor.clear)
            .gradient(layerAxial: data.gradient)
        
    }
}
