//Created  on 2019/7/20 by  LCD:https://github.com/liucaide .

/***** 模块文档 *****
 *
 */




import UIKit

public class View_TopRight: UIView {
    public static let bundle:String = "UtilityViews"
    @IBOutlet weak var stack_bg: UIStackView!
    @IBOutlet weak var view_badge: UIView!
    @IBOutlet weak var btn_icon: UIButton!
    @IBOutlet weak var btn_title: UIButton!
    @IBOutlet weak var lab_badge: UILabel!
    public var num_max:(Int, String) = (99, "99+")
    public var num:Int = 0 {
        didSet{
            view_badge.cd.isHidden(num <= 0)
            if num > num_max.0 {
                lab_badge.cd.text(num_max.1)
            }else{
                lab_badge.cd.text(num.stringValue)
            }
        }
    }
    public var icon:UIImage? {
        didSet{
            btn_icon.cd.image(icon)
        }
    }
    public var title:String = "" {
        didSet{
            btn_title.cd
                .isHidden(title.isEmpty)
                .text(title)
        }
    }
    public var titleColor:UIColor = .white {
        didSet{
            btn_title.cd.text(titleColor)
        }
    }
    var callback:(()->Void)? = nil
    override public func awakeFromNib() {
        super.awakeFromNib()
        view_badge.cd.background(Config.color.hex("FF3B30"))
        btn_title.cd.text(Config.font.font(10))
    }
    
    public static func show(icon:UIImage, title:String, titleColor:UIColor = .white, click:(()->Void)? = nil) -> View_TopRight {
        
        let v = View_TopRight.cd_loadNib(from: View_TopRight.bundle)?.first as! View_TopRight
            //View_TopRight.cd_loadNib()?.first as! View_TopRight
        v.icon = icon
        v.title = title
        v.titleColor = titleColor
        v.callback = click
        v.num = 0
        return v
    }
    
    @IBAction func buttonClick(_ sender: UIButton) {
        callback?()
    }
    
}
