//
//  Date+.swift
//  YTBase_Example
//
//  Created by YouT on 2020/9/16.
//  Copyright © 2020 CocoaPods. All rights reserved.
//

import Foundation

public extension Date {
    func getDateStr(_ dateFormat:String = "yyyyMMddHHmmss") -> String {
        let dateF = DateFormatter()
        dateF.locale = Locale.init(identifier: "en_US")
        dateF.calendar = Calendar.init(identifier: .iso8601)
        dateF.dateFormat = dateFormat
        return dateF.string(from: self)
    }
    
    func string(_ format:String? = "yyyy-MM-dd") -> String {
        let dateF = DateFormatter()
        dateF.locale = Locale.init(identifier: "en_US")
        dateF.calendar = Calendar.init(identifier: .iso8601)
        dateF.dateFormat = format!
        return dateF.string(from: self)
    }
}
