//
//  UIImage+.swift
//  YTBase_Example
//
//  Created by YouT on 2020/9/16.
//  Copyright © 2020 CocoaPods. All rights reserved.
//

import UIKit

public extension UIImage {
    
    //  从bundle加载图片
    class func loadImageFromBundle(in theBundle: Bundle, nameed:String) -> UIImage? {
        return Bundle.getImage(in: theBundle, nameed: nameed)
    }
    
    //  等比例压缩到最大（长\宽）
    func imageWithMaxSize(_ maxsize: CGFloat) ->UIImage{
         var size:CGSize = CGSize()
         if self.size.height>self.size.width{
             if self.size.height>=maxsize{
                 size.height = maxsize
                 size.width = self.size.width*(maxsize/self.size.height)
             }else{
                 return self
             }
         }else{
             if self.size.width>=maxsize{
                 size.width = maxsize
                 size.height = self.size.height*(maxsize/self.size.width)
             }else{
                 return self
             }
         }
         UIGraphicsBeginImageContext(size)
         self.draw(in: CGRect(x: 0, y: 0, width: size.width, height: size.height))
         let newImage = UIGraphicsGetImageFromCurrentImageContext()
         UIGraphicsEndImageContext()
         return newImage!
     }
    
    // 生成一张纯色的图片
    static func createImage(color: UIColor, size: CGSize) -> UIImage? {
        let rect = CGRect(origin: CGPoint.zero, size: size)
        UIGraphicsBeginImageContext(size)
        defer {
            UIGraphicsEndImageContext()
        }
        let context = UIGraphicsGetCurrentContext()
        context?.setFillColor(color.cgColor)
        context?.fill(rect)
        let image = UIGraphicsGetImageFromCurrentImageContext()
        return image
    }
    
    // 添加水印方法
    func waterMarkedImage(waterMarkText:String) -> UIImage {
        var fontS:CGFloat = 90.0
        var textAttributes = [NSAttributedString.Key.foregroundColor:UIColor.red, NSAttributedString.Key.font:UIFont.boldSystemFont(ofSize: fontS)]
        var textSize = NSString(string: waterMarkText).size(withAttributes: textAttributes)
        while ((textSize.width > self.size.width-50) && fontS > 10.0) {
            fontS -= 10.0
            textAttributes = [NSAttributedString.Key.foregroundColor:UIColor.red, NSAttributedString.Key.font:UIFont.boldSystemFont(ofSize: fontS)]
            textSize = NSString(string: waterMarkText).size(withAttributes: textAttributes)
        }
        
        let textFrame = CGRect(x: 50, y: self.size.height - textSize.height - 50, width: textSize.width, height: textSize.height)
        // 开始给图片添加文字水印
        UIGraphicsBeginImageContext(self.size)
        self.draw(in: CGRect(x: 0, y: 0, width: self.size.width, height: self.size.height))
        NSString(string: waterMarkText).draw(in: textFrame, withAttributes: textAttributes)
        guard let waterMarkedImage = UIGraphicsGetImageFromCurrentImageContext() else {
            return self
        }
        UIGraphicsEndImageContext()
        return waterMarkedImage
    }
    
}
